/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.block;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import java.io.Serializable;
import org.afree.chart.block.BlockFrame;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleInsets;

public class LineBorder
implements BlockFrame,
Serializable {
    static final long serialVersionUID = 4630356736707233924L;
    private transient PaintType paintType;
    private transient float stroke;
    private transient PathEffect effect;
    private RectangleInsets insets;

    public LineBorder() {
        this(-16777216, 1.0f, null, new RectangleInsets(1.0, 1.0, 1.0, 1.0));
    }

    public LineBorder(int paint, float stroke, PathEffect effect, RectangleInsets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        this.paintType = new SolidColor(paint);
        this.stroke = stroke;
        this.effect = effect;
        this.insets = insets;
    }

    public PaintType getPaintType() {
        return this.paintType;
    }

    public RectangleInsets getInsets() {
        return this.insets;
    }

    public float getStroke() {
        return this.stroke;
    }

    public PathEffect getEffect() {
        return this.effect;
    }

    public void draw(Canvas canvas, RectShape area) {
        double w = area.getWidth();
        double h = area.getHeight();
        if (w <= 0.0 || h <= 0.0) {
            return;
        }
        double t = this.insets.calculateTopInset(h);
        double b = this.insets.calculateBottomInset(h);
        double l = this.insets.calculateLeftInset(w);
        double r = this.insets.calculateRightInset(w);
        double x = area.getX();
        double y = area.getY();
        double x0 = x + l / 2.0;
        double x1 = x + w - r / 2.0;
        double y0 = y + h - b / 2.0;
        double y1 = y + t / 2.0;
        Paint paint = PaintUtility.createPaint(1, this.getPaintType(), this.getStroke(), this.getEffect());
        LineShape line = new LineShape();
        if (t > 0.0) {
            line.setLine(x0, y1, x1, y1);
            canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
        }
        if (b > 0.0) {
            line.setLine(x0, y0, x1, y0);
            canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
        }
        if (l > 0.0) {
            line.setLine(x0, y0, x0, y1);
            canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
        }
        if (r > 0.0) {
            line.setLine(x1, y0, x1, y1);
            canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
        }
    }
}

