/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot.dial;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.afree.chart.plot.dial.DialLayer;
import org.afree.chart.plot.dial.DialLayerChangeEvent;
import org.afree.chart.plot.dial.DialLayerChangeListener;

public abstract class AbstractDialLayer
implements DialLayer {
    private boolean visible = true;
    private transient List<DialLayerChangeListener> listenerList = new CopyOnWriteArrayList<DialLayerChangeListener>();

    protected AbstractDialLayer() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractDialLayer)) {
            return false;
        }
        AbstractDialLayer that = (AbstractDialLayer)obj;
        return this.visible == that.visible;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractDialLayer clone = (AbstractDialLayer)super.clone();
        clone.listenerList = new CopyOnWriteArrayList<DialLayerChangeListener>();
        return clone;
    }

    public void addChangeListener(DialLayerChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeChangeListener(DialLayerChangeListener listener) {
        this.listenerList.remove(listener);
    }

    public boolean hasListener(EventListener listener) {
        return this.listenerList.contains(listener);
    }

    protected void notifyListeners(DialLayerChangeEvent event) {
        if (this.listenerList.size() == 0) {
            return;
        }
        int i = this.listenerList.size() - 1;
        while (i >= 0) {
            this.listenerList.get(i).dialLayerChanged(event);
            --i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

