/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot.dial;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.RegionIterator;
import java.io.Serializable;
import org.afree.chart.plot.dial.AbstractDialLayer;
import org.afree.chart.plot.dial.DialFrame;
import org.afree.chart.plot.dial.DialLayerChangeEvent;
import org.afree.chart.plot.dial.DialPlot;
import org.afree.graphics.geom.ArcShape;
import org.afree.graphics.geom.PathShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;

public class ArcDialFrame
extends AbstractDialLayer
implements DialFrame,
Cloneable,
Serializable {
    static final long serialVersionUID = -4089176959553523499L;
    private transient Paint backgroundPaint = new Paint();
    private transient Paint foregroundPaint;
    private transient Float stroke;
    private double startAngle;
    private double extent;
    private double innerRadius;
    private double outerRadius;

    public ArcDialFrame() {
        this(0.0, 180.0);
    }

    public ArcDialFrame(double startAngle, double extent) {
        this.backgroundPaint.setColor(-7829368);
        this.foregroundPaint = new Paint();
        this.foregroundPaint.setColor(Color.argb((int)100, (int)100, (int)100, (int)150));
        this.stroke = Float.valueOf(2.0f);
        this.innerRadius = 0.25;
        this.outerRadius = 0.75;
        this.startAngle = startAngle;
        this.extent = extent;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.backgroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getForegroundPaint() {
        return this.foregroundPaint;
    }

    public void setForegroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.foregroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Float getStroke() {
        return this.stroke;
    }

    public void setStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.stroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("Negative 'radius' argument.");
        }
        this.innerRadius = radius;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("Negative 'radius' argument.");
        }
        this.outerRadius = radius;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double angle) {
        this.startAngle = angle;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getExtent() {
        return this.extent;
    }

    public void setExtent(double extent) {
        this.extent = extent;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Shape getWindow(RectShape frame) {
        RectShape innerFrame = DialPlot.RectShapeByRadius(frame, this.innerRadius, this.innerRadius);
        RectShape outerFrame = DialPlot.RectShapeByRadius(frame, this.outerRadius, this.outerRadius);
        ArcShape outer = new ArcShape(outerFrame, this.startAngle, this.extent, true);
        Path path = new Path();
        path.arcTo(innerFrame.getRectF(), (float)this.startAngle, (float)this.extent);
        path.lineTo(outer.getEndPoint().x, outer.getEndPoint().y);
        path.arcTo(outerFrame.getRectF(), (float)(this.startAngle + this.extent), (float)(-this.extent));
        path.close();
        RectF rect2 = new RectF();
        path.computeBounds(rect2, false);
        PathShape p = new PathShape(path);
        return p;
    }

    protected Shape getOuterWindow(RectShape frame) {
        double radiusMargin = 0.02;
        double angleMargin = 1.5;
        RectShape innerFrame = DialPlot.RectShapeByRadius(frame, this.innerRadius - radiusMargin, this.innerRadius - radiusMargin);
        RectShape outerFrame = DialPlot.RectShapeByRadius(frame, this.outerRadius + radiusMargin, this.outerRadius + radiusMargin);
        ArcShape outer = new ArcShape(outerFrame, this.startAngle - angleMargin + this.extent, (double)((float)(-this.extent + 2.0 * angleMargin)), true);
        Path path = new Path();
        path.arcTo(innerFrame.getRectF(), (float)(this.startAngle + angleMargin), (float)(this.extent - 2.0 * angleMargin));
        path.lineTo(outer.getStartPoint().x, outer.getStartPoint().y);
        path.arcTo(outerFrame.getRectF(), (float)(this.startAngle - angleMargin + this.extent), (float)(-this.extent + 2.0 * angleMargin));
        path.close();
        RectF rect2 = new RectF();
        path.computeBounds(rect2, false);
        PathShape p = new PathShape(path);
        return p;
    }

    public void draw(Canvas canvas, DialPlot plot, RectShape frame, Shape view) {
        Shape window = this.getWindow(frame);
        Shape outerWindow = this.getOuterWindow(frame);
        Region region1 = new Region((int)frame.getMinX(), (int)frame.getMinY(), (int)frame.getMaxX(), (int)frame.getMaxY());
        region1.setPath(outerWindow.getPath(), region1);
        Region region2 = new Region((int)frame.getMinX(), (int)frame.getMinY(), (int)frame.getMaxX(), (int)frame.getMaxY());
        region2.setPath(window.getPath(), region2);
        region1.op(region2, Region.Op.XOR);
        Rect rect = new Rect();
        RegionIterator iterator = new RegionIterator(region1);
        this.foregroundPaint.setStyle(Paint.Style.FILL);
        this.foregroundPaint.setColor(-7829368);
        while (iterator.next(rect)) {
            canvas.drawRect(rect, this.foregroundPaint);
        }
        this.foregroundPaint.setStyle(Paint.Style.STROKE);
        this.foregroundPaint.setColor(-12303292);
        this.foregroundPaint.setStrokeWidth(this.stroke.floatValue());
        window.draw(canvas, this.foregroundPaint);
        outerWindow.draw(canvas, this.foregroundPaint);
    }

    public boolean isClippedToWindow() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArcDialFrame)) {
            return false;
        }
        ArcDialFrame that = (ArcDialFrame)obj;
        if (this.startAngle != that.startAngle) {
            return false;
        }
        if (this.extent != that.extent) {
            return false;
        }
        if (this.innerRadius != that.innerRadius) {
            return false;
        }
        if (this.outerRadius != that.outerRadius) {
            return false;
        }
        if (!this.stroke.equals(that.stroke)) {
            return false;
        }
        return super.equals(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

