/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.afree.chart.LegendItem;
import org.afree.chart.LegendItemCollection;
import org.afree.chart.annotations.XYAnnotation;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.entity.XYItemEntity;
import org.afree.chart.labels.ItemLabelPosition;
import org.afree.chart.labels.StandardXYSeriesLabelGenerator;
import org.afree.chart.labels.XYItemLabelGenerator;
import org.afree.chart.labels.XYSeriesLabelGenerator;
import org.afree.chart.labels.XYToolTipGenerator;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.DrawingSupplier;
import org.afree.chart.plot.IntervalMarker;
import org.afree.chart.plot.Marker;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.ValueMarker;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.AbstractRenderer;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.chart.text.TextUtilities;
import org.afree.data.Range;
import org.afree.data.general.DatasetUtilities;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.OvalShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.Layer;
import org.afree.ui.LengthAdjustmentType;
import org.afree.ui.RectangleAnchor;
import org.afree.ui.RectangleInsets;
import org.afree.util.ObjectList;
import org.afree.util.ObjectUtilities;

public abstract class AbstractXYItemRenderer
extends AbstractRenderer
implements XYItemRenderer {
    private static final long serialVersionUID = 8019124836026607990L;
    private XYPlot plot;
    private ObjectList itemLabelGeneratorList;
    private XYItemLabelGenerator baseItemLabelGenerator;
    private ObjectList toolTipGeneratorList;
    private XYToolTipGenerator baseToolTipGenerator;
    private List backgroundAnnotations;
    private List foregroundAnnotations;
    private XYSeriesLabelGenerator legendItemLabelGenerator;
    private XYSeriesLabelGenerator legendItemToolTipGenerator;
    private XYSeriesLabelGenerator legendItemURLGenerator;
    private LineShape mWorkLineShape = new LineShape();

    protected AbstractXYItemRenderer() {
        this.itemLabelGeneratorList = new ObjectList();
        this.toolTipGeneratorList = new ObjectList();
        this.backgroundAnnotations = new ArrayList();
        this.foregroundAnnotations = new ArrayList();
        this.legendItemLabelGenerator = new StandardXYSeriesLabelGenerator("{0}");
    }

    public int getPassCount() {
        return 1;
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public void setPlot(XYPlot plot) {
        this.plot = plot;
    }

    public XYItemRendererState initialise(Canvas canvas, RectShape dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        XYItemRendererState state = new XYItemRendererState(info);
        return state;
    }

    public XYItemLabelGenerator getItemLabelGenerator(int series, int item) {
        XYItemLabelGenerator generator = (XYItemLabelGenerator)this.itemLabelGeneratorList.get(series);
        if (generator == null) {
            generator = this.baseItemLabelGenerator;
        }
        return generator;
    }

    public XYItemLabelGenerator getSeriesItemLabelGenerator(int series) {
        return (XYItemLabelGenerator)this.itemLabelGeneratorList.get(series);
    }

    public void setSeriesItemLabelGenerator(int series, XYItemLabelGenerator generator) {
        this.itemLabelGeneratorList.set(series, generator);
        this.fireChangeEvent();
    }

    public XYItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    public void setBaseItemLabelGenerator(XYItemLabelGenerator generator) {
        this.baseItemLabelGenerator = generator;
        this.fireChangeEvent();
    }

    public XYToolTipGenerator getToolTipGenerator(int series, int item) {
        XYToolTipGenerator generator = (XYToolTipGenerator)this.toolTipGeneratorList.get(series);
        if (generator == null) {
            generator = this.baseToolTipGenerator;
        }
        return generator;
    }

    public XYToolTipGenerator getSeriesToolTipGenerator(int series) {
        return (XYToolTipGenerator)this.toolTipGeneratorList.get(series);
    }

    public void addAnnotation(XYAnnotation annotation) {
        this.addAnnotation(annotation, Layer.FOREGROUND);
    }

    public void addAnnotation(XYAnnotation annotation, Layer layer) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        if (layer.equals(Layer.FOREGROUND)) {
            this.foregroundAnnotations.add(annotation);
            this.fireChangeEvent();
        } else if (layer.equals(Layer.BACKGROUND)) {
            this.backgroundAnnotations.add(annotation);
            this.fireChangeEvent();
        } else {
            throw new RuntimeException("Unknown layer.");
        }
    }

    public boolean removeAnnotation(XYAnnotation annotation) {
        boolean removed = this.foregroundAnnotations.remove(annotation);
        this.fireChangeEvent();
        return removed &= this.backgroundAnnotations.remove(annotation);
    }

    public void removeAnnotations() {
        this.foregroundAnnotations.clear();
        this.backgroundAnnotations.clear();
        this.fireChangeEvent();
    }

    public Collection getAnnotations() {
        ArrayList result = new ArrayList(this.foregroundAnnotations);
        result.addAll(this.backgroundAnnotations);
        return result;
    }

    public XYSeriesLabelGenerator getLegendItemLabelGenerator() {
        return this.legendItemLabelGenerator;
    }

    public void setLegendItemLabelGenerator(XYSeriesLabelGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendItemLabelGenerator = generator;
        this.fireChangeEvent();
    }

    public Range findDomainBounds(XYDataset dataset) {
        return this.findDomainBounds(dataset, false);
    }

    protected Range findDomainBounds(XYDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> visibleSeriesKeys = new ArrayList<Comparable>();
            int seriesCount = dataset.getSeriesCount();
            int s = 0;
            while (s < seriesCount) {
                if (this.isSeriesVisible(s)) {
                    visibleSeriesKeys.add(dataset.getSeriesKey(s));
                }
                ++s;
            }
            return DatasetUtilities.findDomainBounds(dataset, visibleSeriesKeys, includeInterval);
        }
        return DatasetUtilities.findDomainBounds(dataset, includeInterval);
    }

    public Range findRangeBounds(XYDataset dataset) {
        return this.findRangeBounds(dataset, false);
    }

    protected Range findRangeBounds(XYDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> visibleSeriesKeys = new ArrayList<Comparable>();
            int seriesCount = dataset.getSeriesCount();
            int s = 0;
            while (s < seriesCount) {
                if (this.isSeriesVisible(s)) {
                    visibleSeriesKeys.add(dataset.getSeriesKey(s));
                }
                ++s;
            }
            Range xRange = null;
            XYPlot p = this.getPlot();
            if (p != null) {
                ValueAxis xAxis = null;
                int index = p.getIndexOf(this);
                if (index >= 0) {
                    xAxis = this.plot.getDomainAxisForDataset(index);
                }
                if (xAxis != null) {
                    xRange = xAxis.getRange();
                }
            }
            if (xRange == null) {
                xRange = new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            }
            return DatasetUtilities.findRangeBounds(dataset, visibleSeriesKeys, xRange, includeInterval);
        }
        return DatasetUtilities.findRangeBounds(dataset, includeInterval);
    }

    public LegendItemCollection getLegendItems() {
        if (this.plot == null) {
            return new LegendItemCollection();
        }
        LegendItemCollection result = new LegendItemCollection();
        int index = this.plot.getIndexOf(this);
        XYDataset dataset = this.plot.getDataset(index);
        if (dataset != null) {
            int seriesCount = dataset.getSeriesCount();
            int i = 0;
            while (i < seriesCount) {
                LegendItem item;
                if (this.isSeriesVisibleInLegend(i) && (item = this.getLegendItem(index, i)) != null) {
                    result.add(item);
                }
                ++i;
            }
        }
        return result;
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        XYDataset dataset;
        LegendItem result = null;
        XYPlot xyplot = this.getPlot();
        if (xyplot != null && (dataset = xyplot.getDataset(datasetIndex)) != null) {
            String label;
            String description = label = this.legendItemLabelGenerator.generateLabel(dataset, series);
            Shape shape = this.lookupLegendShape(series);
            PaintType paintType = this.lookupSeriesPaintType(series);
            PaintType outlinePaintType = this.lookupSeriesOutlinePaintType(series);
            Float outlineStroke = this.lookupSeriesOutlineStroke(series);
            result = new LegendItem(label, description, "", "", shape, paintType, outlineStroke.floatValue(), outlinePaintType);
            PaintType labelPaintType = this.lookupLegendTextPaintType(series);
            result.setLabelFont(this.lookupLegendTextFont(series));
            if (labelPaintType != null) {
                result.setLabelPaintType(labelPaintType);
            }
            result.setSeriesKey(dataset.getSeriesKey(series));
            result.setSeriesIndex(series);
            result.setDataset(dataset);
            result.setDatasetIndex(datasetIndex);
        }
        return result;
    }

    public void fillDomainGridBand(Canvas canvas, XYPlot plot, ValueAxis axis, RectShape dataArea, double start, double end) {
        double x1 = axis.valueToJava2D(start, dataArea, plot.getDomainAxisEdge());
        double x2 = axis.valueToJava2D(end, dataArea, plot.getDomainAxisEdge());
        RectShape band = plot.getOrientation() == PlotOrientation.VERTICAL ? new RectShape(Math.min(x1, x2), (double)dataArea.getMinY(), Math.abs(x2 - x1), (double)dataArea.getHeight()) : new RectShape((double)dataArea.getMinX(), Math.min(x1, x2), (double)dataArea.getWidth(), Math.abs(x2 - x1));
        PaintType paintType = plot.getDomainTickBandPaintType();
        if (paintType != null) {
            Paint paint = PaintUtility.createPaint(1, paintType);
            band.fill(canvas, paint);
        }
    }

    public void fillRangeGridBand(Canvas canvas, XYPlot plot, ValueAxis axis, RectShape dataArea, double start, double end) {
        double y1 = axis.valueToJava2D(start, dataArea, plot.getRangeAxisEdge());
        double y2 = axis.valueToJava2D(end, dataArea, plot.getRangeAxisEdge());
        RectShape band = plot.getOrientation() == PlotOrientation.VERTICAL ? new RectShape((double)dataArea.getMinX(), Math.min(y1, y2), (double)dataArea.getWidth(), Math.abs(y2 - y1)) : new RectShape(Math.min(y1, y2), (double)dataArea.getMinY(), Math.abs(y2 - y1), (double)dataArea.getHeight());
        Paint paint = PaintUtility.createPaint(plot.getRangeTickBandPaintType());
        if (paint != null) {
            band.fill(canvas, paint);
        }
    }

    public void drawDomainGridLine(Canvas canvas, XYPlot plot, ValueAxis axis, RectShape dataArea, double value) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        double v = axis.valueToJava2D(value, dataArea, plot.getDomainAxisEdge());
        LineShape line = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new LineShape((double)dataArea.getMinX(), v, (double)dataArea.getMaxX(), v);
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new LineShape(v, (double)dataArea.getMinY(), v, (double)dataArea.getMaxY());
        }
        PaintType paintType = plot.getDomainGridlinePaintType();
        Float stroke = plot.getDomainGridlineStroke();
        PaintType p = paintType != null ? paintType : Plot.DEFAULT_OUTLINE_PAINT_TYPE;
        Float s = Float.valueOf(stroke != null ? stroke.floatValue() : 0.5f);
        PathEffect pathEffect = null;
        if (stroke.floatValue() != 0.0f) {
            pathEffect = plot.getDomainGridlineEffect();
        }
        Paint paint = PaintUtility.createPaint(p, s.floatValue(), pathEffect);
        line.draw(canvas, paint);
    }

    public void drawDomainLine(Canvas canvas, XYPlot plot, ValueAxis axis, RectShape dataArea, double value, PaintType paintType, Float stroke, PathEffect effect) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        LineShape line = this.mWorkLineShape;
        double v = axis.valueToJava2D(value, dataArea, plot.getDomainAxisEdge());
        if (orientation == PlotOrientation.HORIZONTAL) {
            line.setLine((double)dataArea.getMinX(), v, (double)dataArea.getMaxX(), v);
        } else if (orientation == PlotOrientation.VERTICAL) {
            line.setLine(v, (double)dataArea.getMinY(), v, (double)dataArea.getMaxY());
        }
        Paint paint = PaintUtility.createPaint(paintType, stroke.floatValue(), effect);
        line.draw(canvas, paint);
    }

    public void drawRangeLine(Canvas canvas, XYPlot plot, ValueAxis axis, RectShape dataArea, double value, PaintType paintType, Float stroke, PathEffect pathEffect) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        LineShape line = this.mWorkLineShape;
        double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        if (orientation == PlotOrientation.HORIZONTAL) {
            line.setLine(v, (double)dataArea.getMinY(), v, (double)dataArea.getMaxY());
        } else if (orientation == PlotOrientation.VERTICAL) {
            line.setLine((double)dataArea.getMinX(), v, (double)dataArea.getMaxX(), v);
        }
        Paint paint = PaintUtility.createPaint(paintType, stroke.floatValue(), pathEffect);
        line.draw(canvas, paint);
    }

    public void drawDomainMarker(Canvas canvas, XYPlot plot, ValueAxis domainAxis, Marker marker, RectShape dataArea) {
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = domainAxis.getRange();
            if (!range.contains(value)) {
                return;
            }
            double v = domainAxis.valueToJava2D(value, dataArea, plot.getDomainAxisEdge());
            PlotOrientation orientation = plot.getOrientation();
            LineShape line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new LineShape((double)dataArea.getMinX(), v, (double)dataArea.getMaxX(), v);
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new LineShape(v, (double)dataArea.getMinY(), v, (double)dataArea.getMaxY());
            }
            PaintType paintType = marker.getPaintType();
            Float stroke = Float.valueOf(marker.getStroke());
            Paint paint = PaintUtility.createPaint(1, paintType, stroke.floatValue(), marker.getEffect());
            paint.setAlpha(marker.getAlpha());
            line.draw(canvas, paint);
            canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Font labelFont = marker.getLabelFont();
                PaintType labelPaintType = marker.getLabelPaintType();
                Paint labelPaint = PaintUtility.createPaint(1, labelPaintType, labelFont);
                labelPaint.setAlpha(marker.getAlpha());
                RectShape rectShape = new RectShape();
                line.getBounds(rectShape);
                PointF coordinates = this.calculateDomainMarkerTextAnchorPoint(canvas, orientation, dataArea, rectShape, marker.getLabelOffset(), LengthAdjustmentType.EXPAND, anchor);
                TextUtilities.drawAlignedString(label, canvas, coordinates.x, coordinates.y, marker.getLabelTextAnchor(), labelPaint);
            }
        } else if (marker instanceof IntervalMarker) {
            IntervalMarker im = (IntervalMarker)marker;
            double start = im.getStartValue();
            double end = im.getEndValue();
            Range range = domainAxis.getRange();
            if (!range.intersects(start, end)) {
                return;
            }
            double start2d = domainAxis.valueToJava2D(start, dataArea, plot.getDomainAxisEdge());
            double end2d = domainAxis.valueToJava2D(end, dataArea, plot.getDomainAxisEdge());
            double low = Math.min(start2d, end2d);
            double high = Math.max(start2d, end2d);
            PlotOrientation orientation = plot.getOrientation();
            RectShape rect = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                low = Math.max(low, (double)dataArea.getMinY());
                high = Math.min(high, (double)dataArea.getMaxY());
                rect = new RectShape((double)dataArea.getMinX(), low, (double)dataArea.getWidth(), high - low);
            } else if (orientation == PlotOrientation.VERTICAL) {
                low = Math.max(low, (double)dataArea.getMinX());
                high = Math.min(high, (double)dataArea.getMaxX());
                rect = new RectShape(low, (double)dataArea.getMinY(), high - low, (double)dataArea.getHeight());
            }
            Paint paint = PaintUtility.createPaint(1, marker.getPaintType());
            paint.setAlpha(marker.getAlpha());
            rect.fill(canvas, paint);
            if (im.getOutlinePaintType() != null && im.getOutlineStroke() != null) {
                LineShape line;
                if (orientation == PlotOrientation.VERTICAL) {
                    line = new LineShape();
                    double y0 = dataArea.getMinY();
                    double y1 = dataArea.getMaxY();
                    Paint outlinePaint = PaintUtility.createPaint(1, im.getOutlinePaintType(), im.getOutlineStroke().floatValue(), im.getOutlineEffect());
                    outlinePaint.setAlpha(marker.getAlpha());
                    if (range.contains(start)) {
                        line.setLine(start2d, y0, start2d, y1);
                        line.draw(canvas, outlinePaint);
                    }
                    if (range.contains(end)) {
                        line.setLine(end2d, y0, end2d, y1);
                        line.draw(canvas, outlinePaint);
                    }
                } else {
                    line = new LineShape();
                    double x0 = dataArea.getMinX();
                    double x1 = dataArea.getMaxX();
                    Paint outlinePaint = PaintUtility.createPaint(1, im.getOutlinePaintType(), im.getOutlineStroke().floatValue(), im.getOutlineEffect());
                    outlinePaint.setAlpha(marker.getAlpha());
                    if (range.contains(start)) {
                        line.setLine(x0, start2d, x1, start2d);
                        line.draw(canvas, outlinePaint);
                    }
                    if (range.contains(end)) {
                        line.setLine(x0, end2d, x1, end2d);
                        line.draw(canvas, outlinePaint);
                    }
                }
            }
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Paint labelPaint = PaintUtility.createPaint(1, marker.getLabelPaintType(), marker.getLabelFont());
                PointF coordinates = this.calculateDomainMarkerTextAnchorPoint(canvas, orientation, dataArea, rect, marker.getLabelOffset(), marker.getLabelOffsetType(), anchor);
                TextUtilities.drawAlignedString(label, canvas, coordinates.x, coordinates.y, marker.getLabelTextAnchor(), labelPaint);
            }
        }
    }

    protected PointF calculateDomainMarkerTextAnchorPoint(Canvas canvas, PlotOrientation orientation, RectShape dataArea, RectShape markerArea, RectangleInsets markerOffset, LengthAdjustmentType labelOffsetType, RectangleAnchor anchor) {
        RectShape anchorRect = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            anchorRect = markerOffset.createAdjustedRectShape(markerArea, LengthAdjustmentType.CONTRACT, labelOffsetType);
        } else if (orientation == PlotOrientation.VERTICAL) {
            anchorRect = markerOffset.createAdjustedRectShape(markerArea, labelOffsetType, LengthAdjustmentType.CONTRACT);
        }
        return RectangleAnchor.coordinates(anchorRect, anchor);
    }

    public void drawRangeMarker(Canvas canvas, XYPlot plot, ValueAxis rangeAxis, Marker marker, RectShape dataArea) {
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = rangeAxis.getRange();
            if (!range.contains(value)) {
                return;
            }
            double v = rangeAxis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
            PlotOrientation orientation = plot.getOrientation();
            LineShape line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new LineShape(v, (double)dataArea.getMinY(), v, (double)dataArea.getMaxY());
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new LineShape((double)dataArea.getMinX(), v, (double)dataArea.getMaxX(), v);
            }
            Paint markerPaint = PaintUtility.createPaint(1, marker.getPaintType(), marker.getStroke(), marker.getEffect());
            markerPaint.setAlpha(marker.getAlpha());
            line.draw(canvas, markerPaint);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Paint markerLabelPaint = PaintUtility.createPaint(1, marker.getLabelPaintType(), marker.getLabelFont());
                RectShape rectShape = new RectShape();
                line.getBounds(rectShape);
                PointF coordinates = this.calculateRangeMarkerTextAnchorPoint(canvas, orientation, dataArea, rectShape, marker.getLabelOffset(), LengthAdjustmentType.EXPAND, anchor);
                TextUtilities.drawAlignedString(label, canvas, coordinates.x, coordinates.y, marker.getLabelTextAnchor(), markerLabelPaint);
            }
        } else if (marker instanceof IntervalMarker) {
            IntervalMarker im = (IntervalMarker)marker;
            double start = im.getStartValue();
            double end = im.getEndValue();
            Range range = rangeAxis.getRange();
            if (!range.intersects(start, end)) {
                return;
            }
            double start2d = rangeAxis.valueToJava2D(start, dataArea, plot.getRangeAxisEdge());
            double end2d = rangeAxis.valueToJava2D(end, dataArea, plot.getRangeAxisEdge());
            double low = Math.min(start2d, end2d);
            double high = Math.max(start2d, end2d);
            PlotOrientation orientation = plot.getOrientation();
            RectShape rect = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                low = Math.max(low, (double)dataArea.getMinX());
                high = Math.min(high, (double)dataArea.getMaxX());
                rect = new RectShape(low, (double)dataArea.getMinY(), high - low, (double)dataArea.getHeight());
            } else if (orientation == PlotOrientation.VERTICAL) {
                low = Math.max(low, (double)dataArea.getMinY());
                high = Math.min(high, (double)dataArea.getMaxY());
                rect = new RectShape((double)dataArea.getMinX(), low, (double)dataArea.getWidth(), high - low);
            }
            Paint paint = PaintUtility.createPaint(1, marker.getPaintType());
            paint.setAlpha(marker.getAlpha());
            rect.fill(canvas, paint);
            if (im.getOutlinePaintType() != null && im.getOutlineStroke() != null) {
                LineShape line;
                if (orientation == PlotOrientation.VERTICAL) {
                    line = new LineShape();
                    double x0 = dataArea.getMinX();
                    double x1 = dataArea.getMaxX();
                    Paint outlinePaint = PaintUtility.createPaint(1, im.getOutlinePaintType(), im.getOutlineStroke().floatValue(), im.getOutlineEffect());
                    outlinePaint.setAlpha(marker.getAlpha());
                    if (range.contains(start)) {
                        line.setLine(x0, start2d, x1, start2d);
                        line.draw(canvas, outlinePaint);
                    }
                    if (range.contains(end)) {
                        line.setLine(x0, end2d, x1, end2d);
                        line.draw(canvas, outlinePaint);
                    }
                } else {
                    line = new LineShape();
                    double y0 = dataArea.getMinY();
                    double y1 = dataArea.getMaxY();
                    Paint outlinePaint = PaintUtility.createPaint(1, im.getOutlinePaintType(), im.getOutlineStroke().floatValue(), im.getOutlineEffect());
                    outlinePaint.setAlpha(marker.getAlpha());
                    if (range.contains(start)) {
                        line.setLine(start2d, y0, start2d, y1);
                        line.draw(canvas, outlinePaint);
                    }
                    if (range.contains(end)) {
                        line.setLine(end2d, y0, end2d, y1);
                        line.draw(canvas, outlinePaint);
                    }
                }
            }
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                Paint labelPaint = PaintUtility.createPaint(1, marker.getLabelPaintType(), marker.getLabelFont());
                PointF coordinates = this.calculateRangeMarkerTextAnchorPoint(canvas, orientation, dataArea, rect, marker.getLabelOffset(), marker.getLabelOffsetType(), anchor);
                TextUtilities.drawAlignedString(label, canvas, coordinates.x, coordinates.y, marker.getLabelTextAnchor(), labelPaint);
            }
        }
    }

    private PointF calculateRangeMarkerTextAnchorPoint(Canvas canvas, PlotOrientation orientation, RectShape dataArea, RectShape markerArea, RectangleInsets markerOffset, LengthAdjustmentType labelOffsetForRange, RectangleAnchor anchor) {
        RectShape anchorRect = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            anchorRect = markerOffset.createAdjustedRectShape(markerArea, labelOffsetForRange, LengthAdjustmentType.CONTRACT);
        } else if (orientation == PlotOrientation.VERTICAL) {
            anchorRect = markerOffset.createAdjustedRectShape(markerArea, LengthAdjustmentType.CONTRACT, labelOffsetForRange);
        }
        return RectangleAnchor.coordinates(anchorRect, anchor);
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        XYPlot p = this.getPlot();
        if (p != null) {
            result = p.getDrawingSupplier();
        }
        return result;
    }

    protected void updateCrosshairValues(CrosshairState crosshairState, double x, double y, int domainAxisIndex, int rangeAxisIndex, double transX, double transY, PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (crosshairState != null) {
            if (this.plot.isDomainCrosshairLockedOnData()) {
                if (this.plot.isRangeCrosshairLockedOnData()) {
                    crosshairState.updateCrosshairPoint(x, y, domainAxisIndex, rangeAxisIndex, transX, transY, orientation);
                } else {
                    crosshairState.updateCrosshairX(x, domainAxisIndex);
                }
            } else if (this.plot.isRangeCrosshairLockedOnData()) {
                crosshairState.updateCrosshairY(y, rangeAxisIndex);
            }
        }
    }

    protected void drawItemLabel(Canvas canvas, PlotOrientation orientation, XYDataset dataset, int series, int item, double x, double y, boolean negative) {
        XYItemLabelGenerator generator = this.getItemLabelGenerator(series, item);
        if (generator != null) {
            String label = generator.generateLabel(dataset, series, item);
            ItemLabelPosition position = null;
            position = !negative ? this.getPositiveItemLabelPosition(series, item) : this.getNegativeItemLabelPosition(series, item);
            Paint paint = PaintUtility.createPaint(1, this.getItemLabelPaintType(series, item), this.getItemLabelFont(series, item));
            PointF anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), x, y, orientation);
            TextUtilities.drawRotatedString(label, canvas, anchorPoint.x, anchorPoint.y, position.getTextAnchor(), position.getAngle(), position.getRotationAnchor(), paint);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawAnnotations(Canvas canvas, RectShape dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, Layer layer, PlotRenderingInfo info) {
        Iterator iterator = null;
        if (layer.equals(Layer.FOREGROUND)) {
            iterator = this.foregroundAnnotations.iterator();
        } else {
            if (!layer.equals(Layer.BACKGROUND)) {
                throw new RuntimeException("Unknown layer.");
            }
            iterator = this.backgroundAnnotations.iterator();
        }
        while (iterator.hasNext()) {
            XYAnnotation annotation = (XYAnnotation)iterator.next();
            annotation.draw(canvas, this.plot, dataArea, domainAxis, rangeAxis, 0, info);
        }
    }

    protected void addEntity(EntityCollection entities, Shape area, XYDataset dataset, int series, int item, double entityX, double entityY) {
        if (!this.getItemCreateEntity(series, item)) {
            return;
        }
        Shape hotspot = area;
        if (hotspot == null) {
            double r = this.getDefaultEntityRadius();
            double w = r * 2.0;
            hotspot = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new OvalShape(entityX - r, entityY - r, w, w) : new OvalShape(entityY - r, entityX - r, w, w);
        }
        XYItemEntity entity = new XYItemEntity(hotspot, dataset, series, item, "", "");
        entities.add(entity);
    }

    public static boolean isPointInRect(RectShape rect, double x, double y) {
        return x >= (double)rect.getMinX() && x <= (double)rect.getMaxX() && y >= (double)rect.getMinY() && y <= (double)rect.getMaxY();
    }

    public XYSeriesLabelGenerator getLegendItemURLGenerator() {
        return this.legendItemURLGenerator;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractXYItemRenderer)) {
            return false;
        }
        AbstractXYItemRenderer that = (AbstractXYItemRenderer)obj;
        if (!this.itemLabelGeneratorList.equals(that.itemLabelGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelGenerator, that.baseItemLabelGenerator)) {
            return false;
        }
        if (!this.toolTipGeneratorList.equals(that.toolTipGeneratorList)) {
            return false;
        }
        if (!this.foregroundAnnotations.equals(that.foregroundAnnotations)) {
            return false;
        }
        if (!this.backgroundAnnotations.equals(that.backgroundAnnotations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemLabelGenerator, that.legendItemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemToolTipGenerator, that.legendItemToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemURLGenerator, that.legendItemURLGenerator)) {
            return false;
        }
        return super.equals(obj);
    }
}

