/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.util.ArrayList;
import java.util.List;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.afree.data.Range;
import org.afree.data.xy.IntervalXYDataset;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.PathShape;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;

public class DeviationRenderer
extends XYLineAndShapeRenderer {
    private static final long serialVersionUID = 5133843508142509280L;
    private float alpha;

    public DeviationRenderer() {
        this(true, true);
    }

    public DeviationRenderer(boolean lines, boolean shapes) {
        super(lines, shapes);
        super.setDrawSeriesLineAsPath(true);
        this.alpha = 0.5f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("Requires 'alpha' in the range 0.0 to 1.0.");
        }
        this.alpha = alpha;
        this.fireChangeEvent();
    }

    public void setDrawSeriesLineAsPath(boolean flag) {
    }

    public Range findRangeBounds(XYDataset dataset) {
        return this.findRangeBounds(dataset, true);
    }

    public XYItemRendererState initialise(Canvas canvas, RectShape dataArea, XYPlot plot, XYDataset dataset, PlotRenderingInfo info) {
        State state = new State(info);
        state.seriesPath = new PathShape();
        state.setProcessVisibleItemsOnly(false);
        return state;
    }

    public int getPassCount() {
        return 3;
    }

    protected boolean isItemPass(int pass) {
        return pass == 2;
    }

    protected boolean isLinePass(int pass) {
        return pass == 1;
    }

    public void drawItem(Canvas canvas, XYItemRendererState state, RectShape dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        if (!this.getItemVisible(series, item)) {
            return;
        }
        if (pass == 0) {
            IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
            State drState = (State)state;
            double x = intervalDataset.getXValue(series, item);
            double yLow = intervalDataset.getStartYValue(series, item);
            double yHigh = intervalDataset.getEndYValue(series, item);
            RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
            RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
            double xx = domainAxis.valueToJava2D(x, dataArea, xAxisLocation);
            double yyLow = rangeAxis.valueToJava2D(yLow, dataArea, yAxisLocation);
            double yyHigh = rangeAxis.valueToJava2D(yHigh, dataArea, yAxisLocation);
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                drState.lowerCoordinates.add(new double[]{yyLow, xx});
                drState.upperCoordinates.add(new double[]{yyHigh, xx});
            } else if (orientation == PlotOrientation.VERTICAL) {
                drState.lowerCoordinates.add(new double[]{xx, yyLow});
                drState.upperCoordinates.add(new double[]{xx, yyHigh});
            }
            if (item == dataset.getItemCount(series) - 1) {
                PathShape area = new PathShape();
                double[] coords = (double[])drState.lowerCoordinates.get(0);
                area.moveTo((float)coords[0], (float)coords[1]);
                int i = 1;
                while (i < drState.lowerCoordinates.size()) {
                    coords = (double[])drState.lowerCoordinates.get(i);
                    area.lineTo((float)coords[0], (float)coords[1]);
                    ++i;
                }
                int count = drState.upperCoordinates.size();
                coords = (double[])drState.upperCoordinates.get(count - 1);
                area.lineTo((float)coords[0], (float)coords[1]);
                int i2 = count - 2;
                while (i2 >= 0) {
                    coords = (double[])drState.upperCoordinates.get(i2);
                    area.lineTo((float)coords[0], (float)coords[1]);
                    --i2;
                }
                area.closePath();
                Paint paint = PaintUtility.createPaint(1, this.getItemFillPaintType(series, item));
                paint.setAlpha((int)(255.0f * this.alpha));
                area.fill(canvas, paint);
                drState.lowerCoordinates.clear();
                drState.upperCoordinates.clear();
            }
        }
        if (this.isLinePass(pass)) {
            if (item == 0) {
                State s = (State)state;
                s.seriesPath.reset();
                s.setLastPointGood(false);
            }
            if (this.getItemLineVisible(series, item)) {
                this.drawPrimaryLineAsPath(state, canvas, plot, dataset, pass, series, item, domainAxis, rangeAxis, dataArea);
            }
        } else if (this.isItemPass(pass)) {
            EntityCollection entities = null;
            if (info != null) {
                entities = info.getOwner().getEntityCollection();
            }
            this.drawSecondaryPass(canvas, plot, dataset, pass, series, item, domainAxis, dataArea, rangeAxis, crosshairState, entities);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeviationRenderer)) {
            return false;
        }
        DeviationRenderer that = (DeviationRenderer)obj;
        if (this.alpha != that.alpha) {
            return false;
        }
        return super.equals(obj);
    }

    public static class State
    extends XYLineAndShapeRenderer.State {
        public List upperCoordinates;
        public List lowerCoordinates = new ArrayList();

        public State(PlotRenderingInfo info) {
            super(info);
            this.upperCoordinates = new ArrayList();
        }
    }
}

