/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import java.io.Serializable;
import org.afree.chart.LegendItem;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.labels.XYToolTipGenerator;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.AbstractXYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.chart.urls.XYURLGenerator;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.PathShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.RectangleEdge;
import org.afree.util.BooleanList;
import org.afree.util.ShapeUtilities;
import org.afree.util.UnitType;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3271351259436865995L;
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    public static final int DISCONTINUOUS = 8;
    public static final int DISCONTINUOUS_LINES = 10;
    private boolean baseShapesVisible;
    private boolean plotLines;
    private boolean plotImages;
    private boolean plotDiscontinuous;
    private UnitType gapThresholdType = UnitType.RELATIVE;
    private double gapThreshold = 1.0;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private boolean baseShapesFilled;
    private boolean drawSeriesLineAsPath;
    private transient Shape legendLine;

    public StandardXYItemRenderer() {
        this(2, null);
    }

    public StandardXYItemRenderer(int type) {
        this(type, null);
    }

    public StandardXYItemRenderer(int type, XYToolTipGenerator toolTipGenerator) {
        this(type, toolTipGenerator, null);
    }

    public StandardXYItemRenderer(int type, XYToolTipGenerator toolTipGenerator, XYURLGenerator urlGenerator) {
        if ((type & 1) != 0) {
            this.baseShapesVisible = true;
        }
        if ((type & 2) != 0) {
            this.plotLines = true;
        }
        if ((type & 4) != 0) {
            this.plotImages = true;
        }
        if ((type & 8) != 0) {
            this.plotDiscontinuous = true;
        }
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.baseShapesFilled = true;
        this.legendLine = new LineShape(-7.0, 0.0, 7.0, 0.0);
        this.drawSeriesLineAsPath = false;
    }

    public boolean getBaseShapesVisible() {
        return this.baseShapesVisible;
    }

    public void setBaseShapesVisible(boolean flag) {
        if (this.baseShapesVisible != flag) {
            this.baseShapesVisible = flag;
            this.fireChangeEvent();
        }
    }

    public boolean getItemShapeFilled(int series, int item) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean flag = this.seriesShapesFilled.getBoolean(series);
        if (flag != null) {
            return flag;
        }
        return this.baseShapesFilled;
    }

    public void setShapesFilled(Boolean filled) {
        this.shapesFilled = filled;
        this.fireChangeEvent();
    }

    public Boolean getSeriesShapesFilled(int series) {
        return this.seriesShapesFilled.getBoolean(series);
    }

    public void setSeriesShapesFilled(int series, Boolean flag) {
        this.seriesShapesFilled.setBoolean(series, flag);
        this.fireChangeEvent();
    }

    public boolean getBaseShapesFilled() {
        return this.baseShapesFilled;
    }

    public void setBaseShapesFilled(boolean flag) {
        this.baseShapesFilled = flag;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public void setPlotLines(boolean flag) {
        if (this.plotLines != flag) {
            this.plotLines = flag;
            this.fireChangeEvent();
        }
    }

    public UnitType getGapThresholdType() {
        return this.gapThresholdType;
    }

    public void setGapThresholdType(UnitType thresholdType) {
        if (thresholdType == null) {
            throw new IllegalArgumentException("Null 'thresholdType' argument.");
        }
        this.gapThresholdType = thresholdType;
        this.fireChangeEvent();
    }

    public double getGapThreshold() {
        return this.gapThreshold;
    }

    public void setGapThreshold(double t) {
        this.gapThreshold = t;
        this.fireChangeEvent();
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    public void setPlotImages(boolean flag) {
        if (this.plotImages != flag) {
            this.plotImages = flag;
            this.fireChangeEvent();
        }
    }

    public boolean getPlotDiscontinuous() {
        return this.plotDiscontinuous;
    }

    public void setPlotDiscontinuous(boolean flag) {
        if (this.plotDiscontinuous != flag) {
            this.plotDiscontinuous = flag;
            this.fireChangeEvent();
        }
    }

    public boolean getDrawSeriesLineAsPath() {
        return this.drawSeriesLineAsPath;
    }

    public void setDrawSeriesLineAsPath(boolean flag) {
        this.drawSeriesLineAsPath = flag;
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape line) {
        if (line == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.legendLine = line;
        this.fireChangeEvent();
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        XYPlot plot = this.getPlot();
        if (plot == null) {
            return null;
        }
        LegendItem result = null;
        XYDataset dataset = plot.getDataset(datasetIndex);
        if (dataset != null && this.getItemVisible(series, 0)) {
            PaintType paintType;
            String label;
            String description = label = this.getLegendItemLabelGenerator().generateLabel(dataset, series);
            String toolTipText = null;
            String urlText = null;
            if (this.getLegendItemURLGenerator() != null) {
                urlText = this.getLegendItemURLGenerator().generateLabel(dataset, series);
            }
            Shape shape = this.lookupLegendShape(series);
            boolean shapeFilled = this.getItemShapeFilled(series, 0);
            PaintType linePaintType = paintType = this.lookupSeriesPaintType(series);
            Float lineStroke = Float.valueOf(this.lookupSeriesStroke(series));
            result = new LegendItem(label, description, toolTipText, urlText, this.baseShapesVisible, shape, shapeFilled, paintType, !shapeFilled, paintType, lineStroke.floatValue(), this.plotLines, this.legendLine, lineStroke.floatValue(), linePaintType);
            result.setLabelFont(this.lookupLegendTextFont(series));
            PaintType labelPaintType = this.lookupLegendTextPaintType(series);
            if (labelPaintType != null) {
                result.setLabelPaintType(labelPaintType);
            }
            result.setDataset(dataset);
            result.setDatasetIndex(datasetIndex);
            result.setSeriesKey(dataset.getSeriesKey(series));
            result.setSeriesIndex(series);
        }
        return result;
    }

    public XYItemRendererState initialise(Canvas canvas, RectShape dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        State state = new State(info);
        state.seriesPath = new PathShape();
        state.seriesIndex = -1;
        return state;
    }

    public void drawItem(Canvas canvas, XYItemRendererState state, RectShape dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        boolean itemVisible = this.getItemVisible(series, item);
        Shape entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        PlotOrientation orientation = plot.getOrientation();
        PaintType paintType = this.getItemPaintType(series, item);
        Float seriesStroke = this.getItemStroke(series, item);
        PathEffect effect = this.getItemEffect(series, item);
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        if (Double.isNaN(x1) || Double.isNaN(y1)) {
            itemVisible = false;
        }
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (this.getPlotLines()) {
            if (this.drawSeriesLineAsPath) {
                State s = (State)state;
                if (s.getSeriesIndex() != series) {
                    s.seriesPath.reset();
                    s.lastPointGood = false;
                    s.setSeriesIndex(series);
                }
                if (itemVisible && !Double.isNaN(transX1) && !Double.isNaN(transY1)) {
                    float x = (float)transX1;
                    float y = (float)transY1;
                    if (orientation == PlotOrientation.HORIZONTAL) {
                        x = (float)transY1;
                        y = (float)transX1;
                    }
                    if (s.isLastPointGood()) {
                        s.seriesPath.lineTo(x, y);
                    } else {
                        s.seriesPath.moveTo(x, y);
                    }
                    s.setLastPointGood(true);
                } else {
                    s.setLastPointGood(false);
                }
                if (item == dataset.getItemCount(series) - 1 && s.seriesIndex == series) {
                    Paint paint = PaintUtility.createPaint(1, this.lookupSeriesPaintType(series), this.lookupSeriesStroke(series), this.lookupSeriesEffect(series));
                    s.seriesPath.draw(canvas, paint);
                }
            } else if (item != 0 && itemVisible) {
                double x0 = dataset.getXValue(series, item - 1);
                double y0 = dataset.getYValue(series, item - 1);
                if (!Double.isNaN(x0) && !Double.isNaN(y0)) {
                    boolean drawLine = true;
                    if (this.getPlotDiscontinuous()) {
                        int numX = dataset.getItemCount(series);
                        double minX = dataset.getXValue(series, 0);
                        double maxX = dataset.getXValue(series, numX - 1);
                        if (this.gapThresholdType == UnitType.ABSOLUTE) {
                            drawLine = Math.abs(x1 - x0) <= this.gapThreshold;
                        } else {
                            boolean bl = drawLine = Math.abs(x1 - x0) <= (maxX - minX) / (double)numX * this.getGapThreshold();
                        }
                    }
                    if (drawLine) {
                        double transX0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
                        double transY0 = rangeAxis.valueToJava2D(y0, dataArea, yAxisLocation);
                        if (Double.isNaN(transX0) || Double.isNaN(transY0) || Double.isNaN(transX1) || Double.isNaN(transY1)) {
                            return;
                        }
                        if (orientation == PlotOrientation.HORIZONTAL) {
                            state.workingLine.setLine(transY0, transX0, transY1, transX1);
                        } else if (orientation == PlotOrientation.VERTICAL) {
                            state.workingLine.setLine(transX0, transY0, transX1, transY1);
                        }
                        if (state.workingLine.intersects(dataArea)) {
                            Paint paint = PaintUtility.createPaint(1, paintType, seriesStroke.floatValue(), effect);
                            state.workingLine.draw(canvas, paint);
                        }
                    }
                }
            }
        }
        if (!itemVisible) {
            return;
        }
        if (this.getBaseShapesVisible()) {
            Shape shape = this.getItemShape(series, item);
            if (orientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, transY1, transX1);
            } else if (orientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, transX1, transY1);
            }
            if (shape.intersects(dataArea)) {
                Paint paint = PaintUtility.createPaint(paintType, seriesStroke.floatValue(), effect);
                if (this.getItemShapeFilled(series, item)) {
                    shape.fill(canvas, paint);
                } else {
                    shape.draw(canvas, paint);
                }
            }
            entityArea = shape;
        }
        double xx = transX1;
        double yy = transY1;
        if (orientation == PlotOrientation.HORIZONTAL) {
            xx = transY1;
            yy = transX1;
        }
        int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
        int rangeAxisIndex = plot.getRangeAxisIndex(rangeAxis);
        this.updateCrosshairValues(crosshairState, x1, y1, domainAxisIndex, rangeAxisIndex, transX1, transY1, orientation);
        if (entities != null && StandardXYItemRenderer.isPointInRect(dataArea, xx, yy)) {
            this.addEntity(entities, entityArea, dataset, series, item, xx, yy);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardXYItemRenderer)) {
            return false;
        }
        StandardXYItemRenderer that = (StandardXYItemRenderer)obj;
        if (this.baseShapesVisible != that.baseShapesVisible) {
            return false;
        }
        if (this.plotLines != that.plotLines) {
            return false;
        }
        if (this.plotImages != that.plotImages) {
            return false;
        }
        if (this.plotDiscontinuous != that.plotDiscontinuous) {
            return false;
        }
        if (this.gapThresholdType != that.gapThresholdType) {
            return false;
        }
        if (this.gapThreshold != that.gapThreshold) {
            return false;
        }
        if (!this.seriesShapesFilled.equals(that.seriesShapesFilled)) {
            return false;
        }
        if (this.baseShapesFilled != that.baseShapesFilled) {
            return false;
        }
        if (this.drawSeriesLineAsPath != that.drawSeriesLineAsPath) {
            return false;
        }
        return super.equals(obj);
    }

    public static class State
    extends XYItemRendererState {
        public PathShape seriesPath;
        private int seriesIndex;
        private boolean lastPointGood;

        public State(PlotRenderingInfo info) {
            super(info);
        }

        public boolean isLastPointGood() {
            return this.lastPointGood;
        }

        public void setLastPointGood(boolean good) {
            this.lastPointGood = good;
        }

        public int getSeriesIndex() {
            return this.seriesIndex;
        }

        public void setSeriesIndex(int index) {
            this.seriesIndex = index;
        }
    }
}

