/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.afree.chart.LegendItem;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.labels.ItemLabelAnchor;
import org.afree.chart.labels.ItemLabelPosition;
import org.afree.chart.labels.XYItemLabelGenerator;
import org.afree.chart.labels.XYSeriesLabelGenerator;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.AbstractXYItemRenderer;
import org.afree.chart.renderer.xy.GradientXYBarPainter;
import org.afree.chart.renderer.xy.XYBarPainter;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.chart.text.TextUtilities;
import org.afree.data.Range;
import org.afree.data.general.DatasetUtilities;
import org.afree.data.xy.IntervalXYDataset;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.GradientShaderFactory;
import org.afree.ui.RectangleEdge;
import org.afree.ui.StandardGradientShaderFactory;

public class XYBarRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
Serializable {
    private transient PaintType shadowPaintType;
    private static final long serialVersionUID = 770559577251370036L;
    private static XYBarPainter defaultBarPainter = new GradientXYBarPainter();
    private static boolean defaultShadowsVisible = true;
    private double base;
    private boolean useYInterval;
    private double margin;
    private boolean drawBarOutline;
    private GradientShaderFactory gradientShaderFactory;
    private transient Shape legendBar;
    private ItemLabelPosition positiveItemLabelPositionFallback;
    private ItemLabelPosition negativeItemLabelPositionFallback;
    private XYBarPainter barPainter;
    private boolean shadowsVisible;
    private double shadowXOffset;
    private double shadowYOffset;
    private double barAlignmentFactor;

    public static XYBarPainter getDefaultBarPainter() {
        return defaultBarPainter;
    }

    public static void setDefaultBarPainter(XYBarPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        defaultBarPainter = painter;
    }

    public static boolean getDefaultShadowsVisible() {
        return defaultShadowsVisible;
    }

    public static void setDefaultShadowsVisible(boolean visible) {
        defaultShadowsVisible = visible;
    }

    public XYBarRenderer() {
        this(0.0);
    }

    public XYBarRenderer(double margin) {
        this.margin = margin;
        this.base = 0.0;
        this.useYInterval = false;
        this.gradientShaderFactory = new StandardGradientShaderFactory();
        this.drawBarOutline = false;
        this.legendBar = new RectShape(-3.0, -5.0, 6.0, 10.0);
        this.barPainter = XYBarRenderer.getDefaultBarPainter();
        this.shadowsVisible = XYBarRenderer.getDefaultShadowsVisible();
        this.shadowXOffset = 4.0;
        this.shadowYOffset = 4.0;
        this.barAlignmentFactor = -1.0;
        this.shadowPaintType = new SolidColor(-7829368);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
        this.fireChangeEvent();
    }

    public boolean getUseYInterval() {
        return this.useYInterval;
    }

    public void setUseYInterval(boolean use) {
        if (this.useYInterval != use) {
            this.useYInterval = use;
            this.fireChangeEvent();
        }
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
        this.fireChangeEvent();
    }

    public boolean isDrawBarOutline() {
        return this.drawBarOutline;
    }

    public void setDrawBarOutline(boolean draw) {
        this.drawBarOutline = draw;
        this.fireChangeEvent();
    }

    public GradientShaderFactory getGradientShaderFactory() {
        return this.gradientShaderFactory;
    }

    public void setGradientShaderFactory(GradientShaderFactory factory) {
        this.gradientShaderFactory = factory;
        this.fireChangeEvent();
    }

    public Shape getLegendBar() {
        return this.legendBar;
    }

    public void setLegendBar(Shape bar) {
        if (bar == null) {
            throw new IllegalArgumentException("Null 'bar' argument.");
        }
        this.legendBar = bar;
        this.fireChangeEvent();
    }

    public ItemLabelPosition getPositiveItemLabelPositionFallback() {
        return this.positiveItemLabelPositionFallback;
    }

    public void setPositiveItemLabelPositionFallback(ItemLabelPosition position) {
        this.positiveItemLabelPositionFallback = position;
        this.fireChangeEvent();
    }

    public ItemLabelPosition getNegativeItemLabelPositionFallback() {
        return this.negativeItemLabelPositionFallback;
    }

    public void setNegativeItemLabelPositionFallback(ItemLabelPosition position) {
        this.negativeItemLabelPositionFallback = position;
        this.fireChangeEvent();
    }

    public XYBarPainter getBarPainter() {
        return this.barPainter;
    }

    public void setBarPainter(XYBarPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        this.barPainter = painter;
        this.fireChangeEvent();
    }

    public boolean getShadowsVisible() {
        return this.shadowsVisible;
    }

    public void setShadowVisible(boolean visible) {
        this.shadowsVisible = visible;
        this.fireChangeEvent();
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double offset) {
        this.shadowXOffset = offset;
        this.fireChangeEvent();
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double offset) {
        this.shadowYOffset = offset;
        this.fireChangeEvent();
    }

    public double getBarAlignmentFactor() {
        return this.barAlignmentFactor;
    }

    public void setBarAlignmentFactor(double factor) {
        this.barAlignmentFactor = factor;
        this.fireChangeEvent();
    }

    public XYItemRendererState initialise(Canvas canvas, RectShape dataArea, XYPlot plot, XYDataset dataset, PlotRenderingInfo info) {
        XYBarRendererState state = new XYBarRendererState(info);
        ValueAxis rangeAxis = plot.getRangeAxisForDataset(plot.indexOf(dataset));
        state.setG2Base(rangeAxis.valueToJava2D(this.base, dataArea, plot.getRangeAxisEdge()));
        return state;
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        XYDataset dataset;
        LegendItem result = null;
        XYPlot xyplot = this.getPlot();
        if (xyplot != null && (dataset = xyplot.getDataset(datasetIndex)) != null) {
            String label;
            XYSeriesLabelGenerator lg = this.getLegendItemLabelGenerator();
            String description = label = lg.generateLabel(dataset, series);
            String toolTipText = null;
            String urlText = null;
            if (this.getLegendItemURLGenerator() != null) {
                urlText = this.getLegendItemURLGenerator().generateLabel(dataset, series);
            }
            Shape shape = this.legendBar;
            PaintType paintType = this.lookupSeriesPaintType(series);
            PaintType outlinePaintType = this.lookupSeriesOutlinePaintType(series);
            float outlineStroke = this.lookupSeriesOutlineStroke(series).floatValue();
            result = this.drawBarOutline ? new LegendItem(label, description, toolTipText, urlText, shape, paintType, outlineStroke, outlinePaintType) : new LegendItem(label, description, toolTipText, urlText, shape, paintType);
            result.setLabelFont(this.lookupLegendTextFont(series));
            PaintType labelPaintType = this.lookupLegendTextPaintType(series);
            if (labelPaintType != null) {
                result.setLabelPaintType(labelPaintType);
            }
            result.setDataset(dataset);
            result.setDatasetIndex(datasetIndex);
            result.setSeriesKey(dataset.getSeriesKey(series));
            result.setSeriesIndex(series);
        }
        return result;
    }

    public void drawItem(Canvas canvas, XYItemRendererState state, RectShape dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        double value1;
        double value0;
        if (!this.getItemVisible(series, item)) {
            return;
        }
        IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
        if (this.useYInterval) {
            value0 = intervalDataset.getStartYValue(series, item);
            value1 = intervalDataset.getEndYValue(series, item);
        } else {
            value0 = this.base;
            value1 = intervalDataset.getYValue(series, item);
        }
        if (Double.isNaN(value0) || Double.isNaN(value1)) {
            return;
        }
        if (value0 <= value1 ? !rangeAxis.getRange().intersects(value0, value1) : !rangeAxis.getRange().intersects(value1, value0)) {
            return;
        }
        double translatedValue0 = rangeAxis.valueToJava2D(value0, dataArea, plot.getRangeAxisEdge());
        double translatedValue1 = rangeAxis.valueToJava2D(value1, dataArea, plot.getRangeAxisEdge());
        double bottom = Math.min(translatedValue0, translatedValue1);
        double top = Math.max(translatedValue0, translatedValue1);
        double startX = intervalDataset.getStartXValue(series, item);
        if (Double.isNaN(startX)) {
            return;
        }
        double endX = intervalDataset.getEndXValue(series, item);
        if (Double.isNaN(endX)) {
            return;
        }
        if (startX <= endX ? !domainAxis.getRange().intersects(startX, endX) : !domainAxis.getRange().intersects(endX, startX)) {
            return;
        }
        if (this.barAlignmentFactor >= 0.0 && this.barAlignmentFactor <= 1.0) {
            double x = intervalDataset.getXValue(series, item);
            double interval = endX - startX;
            startX = x - interval * this.barAlignmentFactor;
            endX = startX + interval;
        }
        RectangleEdge location = plot.getDomainAxisEdge();
        double translatedStartX = domainAxis.valueToJava2D(startX, dataArea, location);
        double translatedEndX = domainAxis.valueToJava2D(endX, dataArea, location);
        double translatedWidth = Math.max(1.0, Math.abs(translatedEndX - translatedStartX));
        double left = Math.min(translatedStartX, translatedEndX);
        if (this.getMargin() > 0.0) {
            double cut = translatedWidth * this.getMargin();
            translatedWidth -= cut;
            left += cut / 2.0;
        }
        RectShape bar = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            bottom = Math.max(bottom, (double)dataArea.getMinX());
            top = Math.min(top, (double)dataArea.getMaxX());
            bar = new RectShape(bottom, left, top - bottom, translatedWidth);
        } else if (orientation == PlotOrientation.VERTICAL) {
            bottom = Math.max(bottom, (double)dataArea.getMinY());
            top = Math.min(top, (double)dataArea.getMaxY());
            bar = new RectShape(left, bottom, translatedWidth, top - bottom);
        }
        boolean positive = value1 > 0.0;
        boolean inverted = rangeAxis.isInverted();
        RectangleEdge barBase = orientation == PlotOrientation.HORIZONTAL ? (positive && inverted || !positive && !inverted ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (positive && !inverted || !positive && inverted ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        if (this.getShadowsVisible()) {
            this.barPainter.paintBarShadow(canvas, this, series, item, bar, barBase, !this.useYInterval);
        }
        this.barPainter.paintBar(canvas, this, series, item, bar, barBase);
        if (this.isItemLabelVisible(series, item)) {
            XYItemLabelGenerator generator = this.getItemLabelGenerator(series, item);
            this.drawItemLabel(canvas, dataset, series, item, plot, generator, bar, value1 < 0.0);
        }
        double x1 = (startX + endX) / 2.0;
        double y1 = dataset.getYValue(series, item);
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, location);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, plot.getRangeAxisEdge());
        int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
        int rangeAxisIndex = plot.getRangeAxisIndex(rangeAxis);
        this.updateCrosshairValues(crosshairState, x1, y1, domainAxisIndex, rangeAxisIndex, transX1, transY1, plot.getOrientation());
        EntityCollection entities = state.getEntityCollection();
        if (entities != null) {
            this.addEntity(entities, bar, dataset, series, item, 0.0, 0.0);
        }
    }

    protected void drawItemLabel(Canvas canvas, XYDataset dataset, int series, int item, XYPlot plot, XYItemLabelGenerator generator, RectShape bar, boolean negative) {
        if (generator == null) {
            return;
        }
        String label = generator.generateLabel(dataset, series, item);
        if (label == null) {
            return;
        }
        ItemLabelPosition position = null;
        position = !negative ? this.getPositiveItemLabelPosition(series, item) : this.getNegativeItemLabelPosition(series, item);
        PointF anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), bar, plot.getOrientation());
        Paint paint = PaintUtility.createPaint(1, this.getItemLabelPaintType(series, item), this.getItemLabelFont(series, item));
        TextUtilities.drawRotatedString(label, canvas, anchorPoint.x, anchorPoint.y, position.getTextAnchor(), position.getAngle(), position.getRotationAnchor(), paint);
    }

    private PointF calculateLabelAnchorPoint(ItemLabelAnchor anchor, RectShape bar, PlotOrientation orientation) {
        PointF result = null;
        double offset = this.getItemLabelAnchorOffset();
        double x0 = (double)bar.getX() - offset;
        double x1 = bar.getX();
        double x2 = (double)bar.getX() + offset;
        double x3 = bar.getCenterX();
        double x4 = (double)bar.getMaxX() - offset;
        double x5 = bar.getMaxX();
        double x6 = (double)bar.getMaxX() + offset;
        double y0 = (double)bar.getMaxY() + offset;
        double y1 = bar.getMaxY();
        double y2 = (double)bar.getMaxY() - offset;
        double y3 = bar.getCenterY();
        double y4 = (double)bar.getMinY() + offset;
        double y5 = bar.getMinY();
        double y6 = (double)bar.getMinY() - offset;
        if (anchor == ItemLabelAnchor.CENTER) {
            result = new PointF((float)x3, (float)y3);
        } else if (anchor == ItemLabelAnchor.INSIDE1) {
            result = new PointF((float)x4, (float)y4);
        } else if (anchor == ItemLabelAnchor.INSIDE2) {
            result = new PointF((float)x4, (float)y4);
        } else if (anchor == ItemLabelAnchor.INSIDE3) {
            result = new PointF((float)x4, (float)y3);
        } else if (anchor == ItemLabelAnchor.INSIDE4) {
            result = new PointF((float)x4, (float)y2);
        } else if (anchor == ItemLabelAnchor.INSIDE5) {
            result = new PointF((float)x4, (float)y2);
        } else if (anchor == ItemLabelAnchor.INSIDE6) {
            result = new PointF((float)x3, (float)y2);
        } else if (anchor == ItemLabelAnchor.INSIDE7) {
            result = new PointF((float)x2, (float)y2);
        } else if (anchor == ItemLabelAnchor.INSIDE8) {
            result = new PointF((float)x2, (float)y2);
        } else if (anchor == ItemLabelAnchor.INSIDE9) {
            result = new PointF((float)x2, (float)y3);
        } else if (anchor == ItemLabelAnchor.INSIDE10) {
            result = new PointF((float)x2, (float)y4);
        } else if (anchor == ItemLabelAnchor.INSIDE11) {
            result = new PointF((float)x2, (float)y4);
        } else if (anchor == ItemLabelAnchor.INSIDE12) {
            result = new PointF((float)x3, (float)y4);
        } else if (anchor == ItemLabelAnchor.OUTSIDE1) {
            result = new PointF((float)x5, (float)y6);
        } else if (anchor == ItemLabelAnchor.OUTSIDE2) {
            result = new PointF((float)x6, (float)y5);
        } else if (anchor == ItemLabelAnchor.OUTSIDE3) {
            result = new PointF((float)x6, (float)y3);
        } else if (anchor == ItemLabelAnchor.OUTSIDE4) {
            result = new PointF((float)x6, (float)y1);
        } else if (anchor == ItemLabelAnchor.OUTSIDE5) {
            result = new PointF((float)x5, (float)y0);
        } else if (anchor == ItemLabelAnchor.OUTSIDE6) {
            result = new PointF((float)x3, (float)y0);
        } else if (anchor == ItemLabelAnchor.OUTSIDE7) {
            result = new PointF((float)x1, (float)y0);
        } else if (anchor == ItemLabelAnchor.OUTSIDE8) {
            result = new PointF((float)x0, (float)y1);
        } else if (anchor == ItemLabelAnchor.OUTSIDE9) {
            result = new PointF((float)x0, (float)y3);
        } else if (anchor == ItemLabelAnchor.OUTSIDE10) {
            result = new PointF((float)x0, (float)y5);
        } else if (anchor == ItemLabelAnchor.OUTSIDE11) {
            result = new PointF((float)x1, (float)y6);
        } else if (anchor == ItemLabelAnchor.OUTSIDE12) {
            result = new PointF((float)x3, (float)y6);
        }
        return result;
    }

    private boolean isInternalAnchor(ItemLabelAnchor anchor) {
        return anchor == ItemLabelAnchor.CENTER || anchor == ItemLabelAnchor.INSIDE1 || anchor == ItemLabelAnchor.INSIDE2 || anchor == ItemLabelAnchor.INSIDE3 || anchor == ItemLabelAnchor.INSIDE4 || anchor == ItemLabelAnchor.INSIDE5 || anchor == ItemLabelAnchor.INSIDE6 || anchor == ItemLabelAnchor.INSIDE7 || anchor == ItemLabelAnchor.INSIDE8 || anchor == ItemLabelAnchor.INSIDE9 || anchor == ItemLabelAnchor.INSIDE10 || anchor == ItemLabelAnchor.INSIDE11 || anchor == ItemLabelAnchor.INSIDE12;
    }

    public Range findDomainBounds(XYDataset dataset) {
        if (dataset != null) {
            return DatasetUtilities.findDomainBounds(dataset, true);
        }
        return null;
    }

    public Range findRangeBounds(XYDataset dataset) {
        if (dataset != null) {
            return DatasetUtilities.findRangeBounds(dataset, this.useYInterval);
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        XYBarRenderer result = (XYBarRenderer)super.clone();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYBarRenderer)) {
            return false;
        }
        XYBarRenderer that = (XYBarRenderer)obj;
        if (this.base != that.base) {
            return false;
        }
        if (this.drawBarOutline != that.drawBarOutline) {
            return false;
        }
        if (this.margin != that.margin) {
            return false;
        }
        if (this.useYInterval != that.useYInterval) {
            return false;
        }
        if (!this.barPainter.equals(that.barPainter)) {
            return false;
        }
        if (this.shadowsVisible != that.shadowsVisible) {
            return false;
        }
        if (this.shadowXOffset != that.shadowXOffset) {
            return false;
        }
        if (this.shadowYOffset != that.shadowYOffset) {
            return false;
        }
        if (this.barAlignmentFactor != that.barAlignmentFactor) {
            return false;
        }
        return super.equals(obj);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    public PaintType getShadowPaintType() {
        return this.shadowPaintType;
    }

    public void setShadowPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.shadowPaintType = paintType;
    }

    protected class XYBarRendererState
    extends XYItemRendererState {
        private double g2Base;

        public XYBarRendererState(PlotRenderingInfo info) {
            super(info);
        }

        public double getG2Base() {
            return this.g2Base;
        }

        public void setG2Base(double value) {
            this.g2Base = value;
        }
    }
}

