/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import java.io.Serializable;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.labels.ItemLabelPosition;
import org.afree.chart.labels.XYItemLabelGenerator;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.AbstractXYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.chart.text.TextUtilities;
import org.afree.data.Range;
import org.afree.data.xy.IntervalXYDataset;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.RectangleEdge;
import org.afree.util.ObjectUtilities;
import org.afree.util.PublicCloneable;
import org.afree.util.ShapeUtilities;

public class YIntervalRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2951586537224143260L;
    private XYItemLabelGenerator additionalItemLabelGenerator = null;

    public XYItemLabelGenerator getAdditionalItemLabelGenerator() {
        return this.additionalItemLabelGenerator;
    }

    public void setAdditionalItemLabelGenerator(XYItemLabelGenerator generator) {
        this.additionalItemLabelGenerator = generator;
        this.fireChangeEvent();
    }

    public Range findRangeBounds(XYDataset dataset) {
        return this.findRangeBounds(dataset, true);
    }

    public void drawItem(Canvas canvas, XYItemRendererState state, RectShape dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
        double x = intervalDataset.getXValue(series, item);
        double yLow = intervalDataset.getStartYValue(series, item);
        double yHigh = intervalDataset.getEndYValue(series, item);
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double xx = domainAxis.valueToJava2D(x, dataArea, xAxisLocation);
        double yyLow = rangeAxis.valueToJava2D(yLow, dataArea, yAxisLocation);
        double yyHigh = rangeAxis.valueToJava2D(yHigh, dataArea, yAxisLocation);
        LineShape line = null;
        Shape shape = this.getItemShape(series, item);
        Shape top = null;
        Shape bottom = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new LineShape(yyLow, xx, yyHigh, xx);
            top = ShapeUtilities.createTranslatedShape(shape, yyHigh, xx);
            bottom = ShapeUtilities.createTranslatedShape(shape, yyLow, xx);
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new LineShape(xx, yyLow, xx, yyHigh);
            top = ShapeUtilities.createTranslatedShape(shape, xx, yyHigh);
            bottom = ShapeUtilities.createTranslatedShape(shape, xx, yyLow);
        }
        Paint paint = PaintUtility.createPaint(1, this.getItemPaintType(series, item), this.getItemStroke(series, item).floatValue(), this.getItemEffect(series, item));
        line.draw(canvas, paint);
        top.fill(canvas, paint);
        bottom.fill(canvas, paint);
        if (this.isItemLabelVisible(series, item)) {
            this.drawItemLabel(canvas, orientation, dataset, series, item, xx, yyHigh, false);
            this.drawAdditionalItemLabel(canvas, orientation, dataset, series, item, xx, yyLow);
        }
        if (entities != null) {
            RectShape rectShape = new RectShape();
            line.getBounds(rectShape);
            this.addEntity(entities, rectShape, dataset, series, item, 0.0, 0.0);
        }
    }

    private void drawAdditionalItemLabel(Canvas canvas, PlotOrientation orientation, XYDataset dataset, int series, int item, double x, double y) {
        if (this.additionalItemLabelGenerator == null) {
            return;
        }
        String label = this.additionalItemLabelGenerator.generateLabel(dataset, series, item);
        ItemLabelPosition position = this.getNegativeItemLabelPosition(series, item);
        PointF anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), x, y, orientation);
        Paint paint = PaintUtility.createPaint(1, this.getItemLabelPaintType(series, item), this.getItemLabelFont(series, item));
        TextUtilities.drawRotatedString(label, canvas, anchorPoint.x, anchorPoint.y, position.getTextAnchor(), position.getAngle(), position.getRotationAnchor(), paint);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof YIntervalRenderer)) {
            return false;
        }
        YIntervalRenderer that = (YIntervalRenderer)obj;
        if (!ObjectUtilities.equal(this.additionalItemLabelGenerator, that.additionalItemLabelGenerator)) {
            return false;
        }
        return super.equals(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

