/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.title;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.Shader;
import org.afree.chart.block.AbstractBlock;
import org.afree.chart.block.Block;
import org.afree.chart.block.LengthConstraintType;
import org.afree.chart.block.RectangleConstraint;
import org.afree.graphics.GradientColor;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.GradientShaderFactory;
import org.afree.ui.RectangleAnchor;
import org.afree.ui.Size2D;
import org.afree.ui.StandardGradientShaderFactory;
import org.afree.util.ObjectUtilities;
import org.afree.util.PaintTypeUtilities;
import org.afree.util.PublicCloneable;
import org.afree.util.ShapeUtilities;

public class LegendGraphic
extends AbstractBlock
implements Block,
PublicCloneable {
    static final long serialVersionUID = -1338791523854985009L;
    private boolean shapeVisible;
    private transient Shape shape;
    private RectangleAnchor shapeLocation;
    private RectangleAnchor shapeAnchor;
    private boolean shapeFilled;
    private transient PaintType fillPaintType;
    private GradientShaderFactory shaderFactory;
    private boolean shapeOutlineVisible;
    private transient PaintType outlinePaintType;
    private transient float outlineStroke;
    private transient PathEffect outlineEffect;
    private boolean lineVisible;
    private transient Shape line;
    private transient float lineStroke;
    private transient PathEffect lineEffect;
    private transient PaintType linePaintType;
    private RectShape mWorkRectShape = new RectShape();

    public LegendGraphic(Shape shape, PaintType fillPaintType) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        if (fillPaintType == null) {
            throw new IllegalArgumentException("Null 'fillPaint' argument.");
        }
        this.shapeVisible = true;
        this.shape = shape;
        this.shapeAnchor = RectangleAnchor.CENTER;
        this.shapeLocation = RectangleAnchor.CENTER;
        this.shapeFilled = true;
        this.fillPaintType = fillPaintType;
        this.shaderFactory = new StandardGradientShaderFactory();
        this.setPadding(2.0, 2.0, 2.0, 2.0);
    }

    public boolean isShapeVisible() {
        return this.shapeVisible;
    }

    public void setShapeVisible(boolean visible) {
        this.shapeVisible = visible;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public void setShapeFilled(boolean filled) {
        this.shapeFilled = filled;
    }

    public PaintType getFillPaintType() {
        return this.fillPaintType;
    }

    public void setFillPaintType(PaintType paintType) {
        this.fillPaintType = paintType;
    }

    public GradientShaderFactory getShaderFactory() {
        return this.shaderFactory;
    }

    public void setShaderFactory(GradientShaderFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null 'transformer' argument.");
        }
        this.shaderFactory = factory;
    }

    public boolean isShapeOutlineVisible() {
        return this.shapeOutlineVisible;
    }

    public void setShapeOutlineVisible(boolean visible) {
        this.shapeOutlineVisible = visible;
    }

    public PaintType getOutlinePaintTypw() {
        return this.outlinePaintType;
    }

    public void setOutlinePaintType(PaintType paintType) {
        this.outlinePaintType = paintType;
    }

    public float getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(float stroke) {
        this.outlineStroke = stroke;
    }

    public PathEffect getOutlineEffect() {
        return this.outlineEffect;
    }

    public void setOutlineEffect(PathEffect effect) {
        this.outlineEffect = effect;
    }

    public RectangleAnchor getShapeAnchor() {
        return this.shapeAnchor;
    }

    public void setShapeAnchor(RectangleAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.shapeAnchor = anchor;
    }

    public RectangleAnchor getShapeLocation() {
        return this.shapeLocation;
    }

    public void setShapeLocation(RectangleAnchor location) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        this.shapeLocation = location;
    }

    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public void setLineVisible(boolean visible) {
        this.lineVisible = visible;
    }

    public Shape getLine() {
        return this.line;
    }

    public void setLine(Shape line) {
        this.line = line;
    }

    public PaintType getLinePaintType() {
        return this.linePaintType;
    }

    public void setLinePaintType(PaintType paintType) {
        this.linePaintType = paintType;
    }

    public float getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(float stroke) {
        this.lineStroke = stroke;
    }

    public PathEffect getLineEffect() {
        return this.lineEffect;
    }

    public void setLineEffect(PathEffect effect) {
        this.lineEffect = effect;
    }

    public Size2D arrange(Canvas canvas, RectangleConstraint constraint) {
        RectangleConstraint contentConstraint = this.toContentConstraint(constraint);
        LengthConstraintType w = contentConstraint.getWidthConstraintType();
        LengthConstraintType h = contentConstraint.getHeightConstraintType();
        Size2D contentSize = null;
        if (w == LengthConstraintType.NONE) {
            if (h == LengthConstraintType.NONE) {
                contentSize = this.arrangeNN(canvas);
            } else {
                if (h == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (h == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        } else if (w == LengthConstraintType.RANGE) {
            if (h == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (w == LengthConstraintType.FIXED) {
            if (h == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h == LengthConstraintType.FIXED) {
                contentSize = new Size2D(contentConstraint.getWidth(), contentConstraint.getHeight());
            }
        }
        return new Size2D(this.calculateTotalWidth(contentSize.getWidth()), this.calculateTotalHeight(contentSize.getHeight()));
    }

    protected Size2D arrangeNN(Canvas canvas) {
        RectShape contentSize = new RectShape();
        if (this.line != null) {
            this.line.getBounds(this.mWorkRectShape);
            contentSize.setRect(this.mWorkRectShape);
        }
        if (this.shape != null) {
            this.shape.getBounds(this.mWorkRectShape);
            contentSize = contentSize.createUnion(this.mWorkRectShape);
        }
        return new Size2D(contentSize.getWidth(), contentSize.getHeight());
    }

    public void draw(Canvas canvas, RectShape area) {
        Paint paint;
        PointF location;
        area = this.trimMargin(area);
        this.drawBorder(canvas, area);
        area = this.trimBorder(area);
        area = this.trimPadding(area);
        if (this.lineVisible) {
            location = RectangleAnchor.coordinates(area, this.shapeLocation);
            Shape aLine = ShapeUtilities.createTranslatedShape(this.getLine(), this.shapeAnchor, location.x, location.y);
            paint = PaintUtility.createPaint(1, this.linePaintType, this.lineStroke, this.lineEffect);
            aLine.draw(canvas, paint);
        }
        if (this.shapeVisible) {
            location = RectangleAnchor.coordinates(area, this.shapeLocation);
            Shape s = ShapeUtilities.createTranslatedShape(this.shape, this.shapeAnchor, location.x, location.y);
            paint = PaintUtility.createPaint(1, this.fillPaintType);
            if (this.shapeFilled) {
                if (this.fillPaintType instanceof GradientColor) {
                    LinearGradient shader = this.shaderFactory.create((GradientColor)this.fillPaintType, s);
                    paint.setShader((Shader)shader);
                }
                s.fill(canvas, paint);
            }
            if (this.shapeOutlineVisible) {
                paint = PaintUtility.createPaint(1, this.outlinePaintType, this.outlineStroke, this.outlineEffect);
                s.draw(canvas, paint);
            }
        }
    }

    public Object draw(Canvas canvas, RectShape area, Object params) {
        this.draw(canvas, area);
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LegendGraphic)) {
            return false;
        }
        LegendGraphic that = (LegendGraphic)obj;
        if (this.shapeVisible != that.shapeVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.shape, that.shape)) {
            return false;
        }
        if (this.shapeFilled != that.shapeFilled) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.fillPaintType, that.fillPaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shaderFactory, that.shaderFactory)) {
            return false;
        }
        if (this.shapeOutlineVisible != that.shapeOutlineVisible) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.outlinePaintType, that.outlinePaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(Float.valueOf(this.outlineStroke), Float.valueOf(that.outlineStroke))) {
            return false;
        }
        if (this.shapeAnchor != that.shapeAnchor) {
            return false;
        }
        if (this.shapeLocation != that.shapeLocation) {
            return false;
        }
        if (this.lineVisible != that.lineVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.line, that.line)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.linePaintType, that.linePaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(Float.valueOf(this.lineStroke), Float.valueOf(that.lineStroke))) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = 193;
        result = 37 * result + ObjectUtilities.hashCode(this.fillPaintType);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        LegendGraphic clone = (LegendGraphic)super.clone();
        clone.shape = ShapeUtilities.clone(this.shape);
        clone.line = ShapeUtilities.clone(this.line);
        return clone;
    }
}

