/*
 * Decompiled with CFR 0.152.
 */
package org.afree.data.general;

import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.afree.data.general.Dataset;
import org.afree.data.general.DatasetChangeEvent;
import org.afree.data.general.DatasetChangeListener;
import org.afree.data.general.DatasetGroup;

public abstract class AbstractDataset
implements Dataset,
Cloneable,
Serializable,
ObjectInputValidation {
    private static final long serialVersionUID = 1918768939869230744L;
    private DatasetGroup group = new DatasetGroup();
    private transient List<DatasetChangeListener> listenerList = new CopyOnWriteArrayList<DatasetChangeListener>();

    protected AbstractDataset() {
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Null 'group' argument.");
        }
        this.group = group;
    }

    public void validateObject() throws InvalidObjectException {
        this.fireDatasetChanged();
    }

    public void addChangeListener(DatasetChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeChangeListener(DatasetChangeListener listener) {
        this.listenerList.remove(listener);
    }

    public boolean hasListener(EventListener listener) {
        return this.listenerList.contains(listener);
    }

    protected void notifyListeners(DatasetChangeEvent event) {
        if (this.listenerList.size() == 0) {
            return;
        }
        int i = this.listenerList.size() - 1;
        while (i >= 0) {
            this.listenerList.get(i).datasetChanged(event);
            --i;
        }
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractDataset clone = (AbstractDataset)super.clone();
        clone.listenerList = new CopyOnWriteArrayList<DatasetChangeListener>();
        return clone;
    }
}

