/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.io.OutputSource;

final class ObjectArrayFormatter
implements Formatter {
    public static final ObjectArrayFormatter INSTANCE = new ObjectArrayFormatter();

    ObjectArrayFormatter() {
    }

    public boolean format(JSON json, JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        int i;
        Object[] array = (Object[])o;
        JSONHint hint = context.getHint();
        Class<?> lastClass = null;
        Formatter lastFormatter = null;
        out.append('[');
        for (i = 0; i < array.length; ++i) {
            Object item = array[i];
            if (item == src) {
                item = null;
            }
            if (i != 0) {
                out.append(',');
            }
            if (context.isPrettyPrint()) {
                out.append('\n');
                for (int j = 0; j < context.getDepth() + 1; ++j) {
                    out.append('\t');
                }
            }
            context.enter(i);
            item = json.preformatInternal(context, item);
            if (item == null) {
                NullFormatter.INSTANCE.format(json, context, src, item, out);
            } else if (hint == null) {
                if (item.getClass().equals(lastClass)) {
                    lastFormatter.format(json, context, src, item, out);
                } else {
                    lastFormatter = json.formatInternal(context, item, out);
                    lastClass = item.getClass();
                }
            } else {
                json.formatInternal(context, item, out);
            }
            context.exit();
        }
        if (context.isPrettyPrint() && i > 0) {
            out.append('\n');
            for (int j = 0; j < context.getDepth(); ++j) {
                out.append('\t');
            }
        }
        out.append(']');
        return true;
    }
}

