/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import twitter4j.HashtagEntity;
import twitter4j.TwitterException;

class HashtagEntityJSONImpl
implements HashtagEntity {
    private static final long serialVersionUID = 4068992372784813200L;
    private int start = -1;
    private int end = -1;
    private String text;

    HashtagEntityJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            JSONArray indicesArray = json.getJSONArray("indices");
            this.start = indicesArray.getInt(0);
            this.end = indicesArray.getInt(1);
            if (!json.isNull("text")) {
                this.text = json.getString("text");
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException((Exception)((Object)jsone));
        }
    }

    public String getText() {
        return this.text;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashtagEntityJSONImpl that = (HashtagEntityJSONImpl)o;
        if (this.end != that.end) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        return !(this.text != null ? !this.text.equals(that.text) : that.text != null);
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HashtagEntityJSONImpl{start=" + this.start + ", end=" + this.end + ", text='" + this.text + '\'' + '}';
    }
}

