/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import twitter4j.TwitterException;
import twitter4j.internal.http.HTMLEntity;

public final class ParseUtil {
    private static ThreadLocal<Map<String, SimpleDateFormat>> formatMap = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        protected Map<String, SimpleDateFormat> initialValue() {
            return new HashMap<String, SimpleDateFormat>();
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.initialValue();
        }
    };

    private ParseUtil() {
        throw new AssertionError();
    }

    public static String getUnescapedString(String str, JSONObject json) {
        return HTMLEntity.unescape(ParseUtil.getRawString(str, json));
    }

    public static String getRawString(String name, JSONObject json) {
        try {
            if (json.isNull(name)) {
                return null;
            }
            return json.getString(name);
        }
        catch (JSONException jsone) {
            return null;
        }
    }

    public static String getURLDecodedString(String name, JSONObject json) {
        String returnValue = ParseUtil.getRawString(name, json);
        if (null != returnValue) {
            try {
                returnValue = URLDecoder.decode(returnValue, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public static Date getDate(String name, JSONObject json) throws TwitterException {
        return ParseUtil.getDate(name, json, "EEE MMM d HH:mm:ss z yyyy");
    }

    public static Date getDate(String name, JSONObject json, String format) throws TwitterException {
        String dateStr = ParseUtil.getUnescapedString(name, json);
        if ("null".equals(dateStr) || null == dateStr) {
            return null;
        }
        return ParseUtil.getDate(dateStr, format);
    }

    public static Date getDate(String name, String format) throws TwitterException {
        SimpleDateFormat sdf = formatMap.get().get(format);
        if (null == sdf) {
            sdf = new SimpleDateFormat(format, Locale.ENGLISH);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            formatMap.get().put(format, sdf);
        }
        try {
            return sdf.parse(name);
        }
        catch (ParseException pe) {
            throw new TwitterException("Unexpected date format(" + name + ") returned from twitter.com", pe);
        }
    }

    public static int getInt(String name, JSONObject json) {
        return ParseUtil.getInt(ParseUtil.getRawString(name, json));
    }

    public static int getInt(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return -1;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static long getLong(String name, JSONObject json) {
        return ParseUtil.getLong(ParseUtil.getRawString(name, json));
    }

    public static long getLong(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return -1L;
        }
        if (str.endsWith("+")) {
            str = str.substring(0, str.length() - 1);
            return Long.valueOf(str) + 1L;
        }
        return Long.valueOf(str);
    }

    public static double getDouble(String name, JSONObject json) {
        String str2 = ParseUtil.getRawString(name, json);
        if (null == str2 || "".equals(str2) || "null".equals(str2)) {
            return -1.0;
        }
        return Double.valueOf(str2);
    }

    public static boolean getBoolean(String name, JSONObject json) {
        String str = ParseUtil.getRawString(name, json);
        if (null == str || "null".equals(str)) {
            return false;
        }
        return Boolean.valueOf(str);
    }
}

