package net.atlabo.money.activity;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.adapter.CreditListDialogAdapter;
import net.atlabo.money.adapter.DailyDetailListAdapter;
import net.atlabo.money.dao.BudgetCreditcardExtDao;
import net.atlabo.money.dao.BudgetDao;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.dao.PlanMonthDao;
import net.atlabo.money.db.table.BudgetCreditcardExtTable;
import net.atlabo.money.db.table.BudgetTable;
import net.atlabo.money.listener.OnFlickListener;
import net.atlabo.money.logic.WidgetLogic;
import net.atlabo.money.util.Preference;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

/**
 * ڍׂ擾
 * @author Atsushi Nakamoto
 *
 */
public class DailyDetailActivity extends ExtendedActivity {

	private SimpleDateFormat df = new SimpleDateFormat("MMMMM d, yyyy (EEE.)", Locale.US);
	private SimpleDateFormat df3 = new SimpleDateFormat("yyyyMMdd");
	private SimpleDateFormat df2 = new SimpleDateFormat("yyyyMM");
	private DecimalFormat decimalFormat = new DecimalFormat("###,###,###~");

	private ListView detailListView;
	private OnFlickListener onFlickListener;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.daily_detail);

		onFlickListener = new OnFlickListener(new Handler() {
			public void handleMessage(Message msg) {
				if (msg.what == OnFlickListener.FLICK_LEFT) {
					// tbN
					Calendar cal = Calendar.getInstance();
					cal.setTime(date);
					cal.add(Calendar.DAY_OF_MONTH, 1);
					callThisActivityWithAnim(cal, R.anim.fadein_right, R.anim.fadeout_left);
					finish();
				} else if (msg.what == OnFlickListener.FLICK_RIGHT) {
					Calendar cal = Calendar.getInstance();
					cal.setTime(date);
					cal.add(Calendar.DAY_OF_MONTH, -1);
					callThisActivityWithAnim(cal, R.anim.fadein_left, R.anim.fadeout_right);
					finish();
				}
			}
		});

		// ListView擾
		detailListView = (ListView) findViewById(R.id.detailList);

		// ReLXgj[ǉ
		registerForContextMenu(detailListView);
	}

	public void onResume() {
		super.onResume();

		// tTextView擾
		TextView tvDate = (TextView) findViewById(R.id.date);
		// tݒ
		tvDate.setText(df.format(date));

		// {̏ڍׂ擾
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setReadableDatabase();
		BudgetDao dao = new BudgetDao(manager);
		List<Map<String, Object>> list = dao.selectDailyDetail(df3.format(date));

		// ListViewɏڍׂݒ
		DailyDetailListAdapter adapter
			= new DailyDetailListAdapter(getApplicationContext(), list, date);
		detailListView.setAdapter(adapter);
		// ListView̗vfȈ
		detailListView.setOnItemClickListener(new OnItemClickListener() {
			public void onItemClick(AdapterView<?> arg0, View view, int position,
					long arg3) {
				// memo擾
				String memo = (String) view.getTag(R.string.resource_memo);
				// memoȂꍇ͉Ȃ
				if ("".equals(memo) || memo == null) {
					return;
				}
				// _CAOo
				AlertDialog.Builder builder = new AlertDialog.Builder(DailyDetailActivity.this);
				builder.setTitle("");
				builder.setMessage(memo);
				builder.setPositiveButton("", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						// 邾
					}
				});
				builder.create().show();
			}
		});

		// R[hȂꍇbZ[Wݒ
		if (list.isEmpty()) {
			TextView nothingMsg = (TextView) findViewById(R.id.nothingMsg);
			nothingMsg.setVisibility(View.VISIBLE);
			nothingMsg.setText("o񂪂܂B");
		} else {
			TextView nothingMsg = (TextView) findViewById(R.id.nothingMsg);
			nothingMsg.setVisibility(View.GONE);
		}

		// NWbg^C~O擾
		Preference pref = new Preference(this);
		String timing = pref.getCreditPayTiming();
		
		// v擾
		int totalAmount = 0;
		if (Preference.CREDIT_BUY.equals(timing)) {
			// x
			Log.v("DailyDetailActivity", "xɌv");
			totalAmount = dao.selectDailyTotal(df3.format(date));
		} else {
			// Ƃ
			Log.v("DailyDetailActivity", "Ɍv");
			totalAmount = dao.selectDailyTotalAfterPay(df3.format(date));
		}
		// vݒ
		TextView tvTotalAmount = (TextView) findViewById(R.id.totalAmount);
		tvTotalAmount.setText(decimalFormat.format(totalAmount));

		// ڕW擾
		PlanMonthDao planDao = new PlanMonthDao(manager);
		String strPlanAmount = null;
		Integer planAmount = planDao.selectPlan(df2.format(date));
		if (planAmount == null) {
			strPlanAmount = "-----";
		} else {
			strPlanAmount = decimalFormat.format(planAmount);
		}

		// ڕWݒ
		TextView tvPlanAmount = (TextView) findViewById(R.id.planAmount);
		tvPlanAmount.setText(strPlanAmount);

		// 1擾
		Calendar cal = new GregorianCalendar();
		cal.setTime(date);
		cal.set(Calendar.DAY_OF_MONTH, 1);

		// ݌v擾
		int ruikei = 0;
		if (Preference.CREDIT_BUY.equals(timing)) {
			// x
			ruikei = dao.selectDailyRuikei(df3.format(cal.getTime()), df3.format(date));
		} else {
			// 
			ruikei = dao.selectDailyRuikeiAfterPay(df3.format(cal.getTime()), df3.format(date));
		}
		
		// ݌vݒ
		TextView tvRuikei = (TextView) findViewById(R.id.ruikei);
		tvRuikei.setText(decimalFormat.format(ruikei));

		// 0̏ꍇAToasto
		if (list.isEmpty()) {
			Toast.makeText(this, "o^܂B", Toast.LENGTH_LONG);
		}

		manager.close();
	}


    /**
     * ReLXgj[
     */
    @SuppressWarnings("unchecked")
	public void onCreateContextMenu(ContextMenu menu, View view, ContextMenuInfo info) {
    	super.onCreateContextMenu(menu, view, info);
    	AdapterContextMenuInfo adapterInfo = (AdapterContextMenuInfo) info;
    	ListView listView = (ListView) view;
    	Map<String, Object> map = (Map<String, Object>) listView.getItemAtPosition(adapterInfo.position);

    	// wb_ݒ
    	menu.setHeaderTitle((String) map.get(BudgetTable.COLUMN_CONTENTS));
    	
    	// TX_DATE擾
    	String txDate = (String) map.get(BudgetTable.COLUMN_TX_DATE);
    	
    	if (!txDate.equals(df3.format(date))) {
    		// TX_DATE{ł͂ȂꍇA㕥ݒ̃R[h
    		menu.add(0, 11, 0, "ɂ");
    	} else {
    		// TX_DATE{̏ꍇA̓̃R[h
        	// j[ǉ
        	menu.add(0, 0, 0, "ҏW");
        	menu.add(1, 1, 1, "폜");
    	}
    	

    }

    /**
     * ReLXgj[̏
     */
    @SuppressWarnings("unchecked")
	public boolean onContextItemSelected(final MenuItem item) {
    	// ItemID
    	int itemId = item.getItemId();

    	if (itemId == 0) {
    		// ҏW
	    	AdapterContextMenuInfo adapterInfo = (AdapterContextMenuInfo) item.getMenuInfo();
	    	Map<String, Object> map = (Map<String, Object>) detailListView.getItemAtPosition(adapterInfo.position);
	    	String txId = (String) map.get(BudgetTable.COLUMN_TX_ID);
	    	int amount = (Integer) map.get(BudgetTable.COLUMN_AMOUNT);
	    	String category = (String) map.get(BudgetTable.COLUMN_CATEGORY);
	    	String content = (String) map.get(BudgetTable.COLUMN_CONTENTS);
	    	String memo = (String) map.get(BudgetTable.COLUMN_MEMO);
	    	String txDate = (String) map.get(BudgetTable.COLUMN_TX_DATE);
	    	String status = (String) map.get(BudgetCreditcardExtTable.COLUMN_STATUS);
	    	String finishDate = (String) map.get(BudgetCreditcardExtTable.COLUMN_FINISH_DATE);
	    	String creditcardId = (String) map.get(BudgetCreditcardExtTable.COLUMN_CREDITCARD_ID);

	    	Intent intent = new Intent(this, RegistItem2Activity.class);
	    	intent.putExtra(BudgetTable.COLUMN_TX_ID, txId);
	    	intent.putExtra(BudgetTable.COLUMN_AMOUNT, amount);
	    	intent.putExtra(BudgetTable.COLUMN_CATEGORY, category);
	    	intent.putExtra(BudgetTable.COLUMN_CONTENTS, content);
	    	intent.putExtra(BudgetTable.COLUMN_MEMO, memo);
	    	intent.putExtra(BudgetTable.COLUMN_TX_DATE, txDate);
	    	intent.putExtra(BudgetCreditcardExtTable.COLUMN_STATUS, status);
	    	intent.putExtra(BudgetCreditcardExtTable.COLUMN_FINISH_DATE, finishDate);
	    	intent.putExtra(BudgetCreditcardExtTable.COLUMN_CREDITCARD_ID, creditcardId);
	    	moveActivity(intent);
    	} else if (itemId == 1) {
        	// 폜
        	AlertDialog.Builder builder = new AlertDialog.Builder(this);
        	builder.setTitle("mF");
        	builder.setMessage("{ɍ폜܂H");
        	builder.setPositiveButton("͂", new DialogInterface.OnClickListener() {
    			public void onClick(DialogInterface dialoginterface, int i) {
    				// 폜
    		    	AdapterContextMenuInfo adapterInfo = (AdapterContextMenuInfo) item.getMenuInfo();
    		    	Map<String, Object> map = (Map<String, Object>) detailListView.getItemAtPosition(adapterInfo.position);
    		    	String txId = (String) map.get(BudgetTable.COLUMN_TX_ID);

    		    	// ڍׂ̍폜
    		    	ConnectionManager manager = ConnectionManager.getInstance(DailyDetailActivity.this);
    		    	manager.setWritableDatabase();
    		    	BudgetDao dao = new BudgetDao(manager);
    		    	
    		    	try {
	    		    	dao.deleteDetail(txId);
	
	    				// EBWFbgXV
	    		    	WidgetLogic logic = new WidgetLogic();
	    		    	logic.execute(DailyDetailActivity.this);
	
	    		    	manager.commit();
    		    	} finally {
    		    		manager.endTransaction();
    		    		manager.close();
    		    	}
    		    	
    		    	// ʍĕ\
    		    	Calendar cal = Calendar.getInstance();
    		    	cal.setTime(date);
    		    	callThisActivity(cal);

    			}
    		});
        	builder.setNegativeButton("",  null);
        	builder.create().show();
    	} else if (itemId == 11) {
    		// ɂ
    		AlertDialog.Builder builder = new AlertDialog.Builder(this);
        	builder.setTitle("mF");
        	builder.setMessage("{ɖɂ܂H");
        	builder.setPositiveButton("͂", new DialogInterface.OnClickListener() {
    			public void onClick(DialogInterface dialoginterface, int i) {
    				// 폜
    		    	AdapterContextMenuInfo adapterInfo = (AdapterContextMenuInfo) item.getMenuInfo();
    		    	Map<String, Object> map = (Map<String, Object>) detailListView.getItemAtPosition(adapterInfo.position);
    		    	ConnectionManager manager = ConnectionManager.getInstance(DailyDetailActivity.this);
    		    	manager.setWritableDatabase();
    		    	BudgetCreditcardExtDao dao = new BudgetCreditcardExtDao(manager);
    		    	map.put(BudgetCreditcardExtTable.COLUMN_STATUS, "0"); // ɐݒ
    		    	map.put(BudgetCreditcardExtTable.COLUMN_FINISH_DATE, null); // NULLɐݒ
    		    	dao.update(map);
    		    	manager.commit();
    		    	manager.endTransaction();
    		    	manager.close();
    		    	
    		    	Toast.makeText(DailyDetailActivity.this, "ɂ܂B", Toast.LENGTH_LONG).show();
    		    	
    		    	// ʍĕ\
    		    	Calendar cal = Calendar.getInstance();
    		    	cal.setTime(date);
    		    	callThisActivity(cal);
    			}
        	});
        	builder.setNegativeButton("", null);
        	builder.create().show();
    	}

    	return false;
    }

	/**
	 * ONbNꍇ
	 * @param view
	 */
	public void onLastDayClick(View view) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		callThisActivityWithAnim(cal, R.anim.fadein_left, R.anim.fadeout_right);
		finish();
	}

	/**
	 * ActivityēxĂяo
	 * @param cal
	 */
	private void callThisActivity(Calendar cal) {
		date = cal.getTime();
		moveActivity(DailyDetailActivity.class);
	}

	/**
	 * Aj[VActivityĂяo
	 * @param cal
	 * @param from
	 * @param to
	 */
	private void callThisActivityWithAnim(Calendar cal, int from, int to) {
		date = cal.getTime();
		moveActivityWithAnimation(DailyDetailActivity.class, from, to);
	}

	/**
	 * IvVj[̐
	 */
    public boolean onCreateOptionsMenu(Menu menu) {

        menu.add(1, 1, 1, "{ɖ߂").setIcon(android.R.drawable.ic_menu_revert);
        // ݒ
        menu.add(2, 2, 2, "ݒ").setIcon(android.R.drawable.ic_menu_manage);
        // NWbgJ[h
        menu.add(3, 3, 3, "ڼޯĶ").setIcon(android.R.drawable.ic_menu_send);

        return true;
    }

    /**
     * IvVj[̑I
     */
    public boolean onOptionsItemSelected(MenuItem item) {
    	if (item.getItemId() == 1) {
    		// {ɖ߂{^̏
    		callThisActivity(new GregorianCalendar());
    	} else if (item.getItemId() == 2) {
    		// ݒ{^̏
    		Intent intent = new Intent(this, ConfigActivity.class);
    		startActivity(intent);
    	} else if (item.getItemId() == 3) {
    		// NWbgJ[h̏
    		creditcardClick();
    	}

    	return true;
    }

    /**
     * JeS{^̏
     * @param view
     */
    public void onCategoryClick(View view) {
    	moveActivity(MonthlyCategoryActivity.class);
    }

	/**
	 * Ԃꍇ
	 * @param view
	 */
	public void onMonthlyClick(View view) {
		moveActivity(DailySummaryActivity.class);
	}


	/**
	 * o^{^ꍇ
	 * @param view
	 */
	public void onAddClick(View view) {
		// o^{^̏
		moveActivity(RegistItem2Activity.class);
	}

	@Override
	public boolean dispatchTouchEvent(MotionEvent ev) {
		onFlickListener.onTouch(null, ev);
		return super.dispatchTouchEvent(ev);
	}
	
	/**
	 * NWbgJ[h
	 */
	private void creditcardClick() {
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		
		// NWbgJ[hxꗗ擾
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setReadableDatabase();
		BudgetCreditcardExtDao dao = new BudgetCreditcardExtDao(manager);
		List<Map<String, Object>> list = dao.selectWithNotFinished();
		manager.close();
		
		if (list.isEmpty()) {
			// x݂Ȃꍇ
			Toast.makeText(this, "̃NWbgJ[h̎x܂B", Toast.LENGTH_SHORT).show();
			return;
		}
		
		// vz擾
		int totalAmount = 0;
		for (Map<String, Object> map : list) {
			Integer amount = (Integer) map.get(BudgetTable.COLUMN_AMOUNT);
			totalAmount += amount;
		}
		
		builder.setTitle("zF" + decimalFormat.format(totalAmount));
		
		LayoutInflater inflater = LayoutInflater.from(this);
		View view = inflater.inflate(R.layout.credit_list_dialog, null);
		
		ListView listView = (ListView) view.findViewById(R.id.listview);
		final CreditListDialogAdapter adapter = new CreditListDialogAdapter(this, list);
		listView.setAdapter(adapter);
		
		builder.setView(view);
		builder.setPositiveButton("xςɐݒ", new OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				// `FbNς݂̂̂擾
				boolean[] checks = adapter.getChecks();
				boolean isChecked;
				List<Map<String, Object>> list = new ArrayList<Map<String,Object>>();
				for (int i=0, size=checks.length; i<size; i++) {
					isChecked = checks[i];
					if (!isChecked) {
						// `FbN̂ĂȂ͖̂
						continue;
					}
					list.add(adapter.getItem(i));
				}
				
				if (list.isEmpty()) {
					// 1IĂȂꍇ͏I
					Toast.makeText(DailyDetailActivity.this, "1IĂ܂B", Toast.LENGTH_SHORT).show();
					return;
				}
				
				// xς݂ɐݒ
				registFinishCredit(list);
				
				Toast.makeText(DailyDetailActivity.this, "xς݂ɐݒ肵܂B", Toast.LENGTH_LONG).show();
			}
		});
		builder.setNegativeButton("LZ", null);
		builder.create().show();
	}
	
	/**
	 * NWbgx
	 */
	private void registFinishCredit(List<Map<String, Object>> list) {
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setWritableDatabase();
		BudgetCreditcardExtDao dao = new BudgetCreditcardExtDao(manager);
		
		Map<String, Object> map = null;
		for (Map<String, Object> orgMap : list) {
			map = new HashMap<String, Object>();
			map.put(BudgetCreditcardExtTable.COLUMN_TX_ID, 
					orgMap.get(BudgetCreditcardExtTable.COLUMN_TX_ID));
			map.put(BudgetCreditcardExtTable.COLUMN_STATUS, "1");
			map.put(BudgetCreditcardExtTable.COLUMN_FINISH_DATE, df3.format(date));
			map.put(BudgetCreditcardExtTable.COLUMN_CREDITCARD_ID, 
					orgMap.get(BudgetCreditcardExtTable.COLUMN_CREDITCARD_ID));
			
			Log.v("DailyDetailActivity", "BUDGET_CREDITCARD_EXTXV܂B["
					+ "TX_ID : " + map.get(BudgetCreditcardExtTable.COLUMN_TX_ID) + ", "
					+ "STATUS : " + map.get(BudgetCreditcardExtTable.COLUMN_STATUS) + ", "
					+ "FINISH_DATE : " + map.get(BudgetCreditcardExtTable.COLUMN_FINISH_DATE) + ", "
					+ "CREDITCARD_ID : " + map.get(BudgetCreditcardExtTable.COLUMN_CREDITCARD_ID)
					+ "]");
			dao.update(map);
		}
		manager.commit();
		manager.endTransaction();
		manager.close();
	}
}
