package net.atlabo.money.activity;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.adapter.MonthlyPagerAdapter;
import net.atlabo.money.component.AmountInputDialog;
import net.atlabo.money.dao.BudgetDao;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.dao.PlanMonthDao;
import net.atlabo.money.db.table.BudgetTable;
import net.atlabo.money.db.table.PlanMonthTable;
import net.atlabo.money.db.table.PlanTable;
import net.atlabo.money.logic.WidgetLogic;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.ViewPager;
import android.util.Log;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

/**
 * ̃T}ɕ\
 * @author Atsushi Nakamoto
 *
 */
public class DailySummaryActivity extends ExtendedActivity {

	private SimpleDateFormat df2 = new SimpleDateFormat("yyyyMM");
	private DecimalFormat decimalFormat = new DecimalFormat("###,###,###~");

	private Integer planAmount;
	private ListView detailListView;

	private ViewPager viewPager;
	private MonthlyPagerAdapter adapter;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.daily_summary);

		adapter = new MonthlyPagerAdapter(this, date);
		viewPager = (ViewPager) findViewById(R.id.viewPager);
		viewPager.setAdapter(adapter);
		viewPager.setCurrentItem(MonthlyPagerAdapter.INITIAL);
	}

	public void onResume() {
		super.onResume();
	}

	/**
	 * ActivityēxĂяo
	 * @param cal
	 */
	private void callThisActivity(Calendar cal) {
		date = cal.getTime();
		moveActivity(DailySummaryActivity.class);
		finish();
	}

	/**
	 * IvVj[̐
	 */
    public boolean onCreateOptionsMenu(Menu menu) {

        menu.add(1, 1, 1, "ɖ߂").setIcon(android.R.drawable.ic_menu_revert);
        // ݒ
        menu.add(2, 2, 2, "ݒ").setIcon(android.R.drawable.ic_menu_manage);

        return true;
    }

    /**
     * IvVj[̑I
     */
    public boolean onOptionsItemSelected(MenuItem item) {
    	if (item.getItemId() == 1) {
    		// ɖ߂{^̏
    		Log.v("money", "ɖ߂{^");
    		callThisActivity(new GregorianCalendar());
    	} else if (item.getItemId() == 2) {
    		// ݒ{^̏
    		Intent intent = new Intent(this, ConfigActivity.class);
    		startActivity(intent);
    	}

    	return true;
    }

    /**
     * ڕWݒ{^
     * @param view
     */
    public void onPlanClick(View view) {
		Handler handler = new Handler() {
			public void handleMessage(Message msg) {
				int what = msg.what;
				if (what == AmountInputDialog.CLICK_OK) {
					// ڕWo^
					registPlan(msg);
					finish();
				}
			}
		};

		// ݒl擾
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setReadableDatabase();
		PlanMonthDao dao = new PlanMonthDao(manager);
		Integer planAmount = dao.selectPlan(df2.format(adapter.getCurrentDate(viewPager.getCurrentItem())));

		AmountInputDialog d = new AmountInputDialog(DailySummaryActivity.this, handler);
		d.showDialog(planAmount);

		manager.close();
    }

    /**
     * ڕW̓o^
     * @param msg
     */
    private void registPlan(Message msg) {
		String strAmount = msg.getData().getString(AmountInputDialog.STR_AMOUNT);

		// lݒ肳ĂȂꍇAI
		if (strAmount == null || "".equals(strAmount)) {
			return;
		}

		planAmount =Integer.parseInt(strAmount
				.replaceAll(",", "")
				.replaceAll("~", ""));

		// ڕW̓o^
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setWritableDatabase();
		PlanMonthDao dao = new PlanMonthDao(manager);
		Map<String, Object> map = new HashMap<String, Object>();
		map.put(PlanMonthTable.COLUMN_TX_MONTH, df2.format(adapter.getCurrentDate(viewPager.getCurrentItem())));
		map.put(PlanTable.COLUMN_PLAN_AMOUNT, planAmount);

		try {
			Integer i = dao.selectPlan((String) map.get(PlanMonthTable.COLUMN_TX_MONTH));
			if (i == null) {
				dao.insertPlan(map);
			} else {
				dao.updatePlan(map);
			}
			// ڕWXV
			String strPlanAmount = null;
			strPlanAmount = decimalFormat.format(planAmount);
	
			// ڕWݒ
			TextView tvPlanAmount = (TextView) findViewById(R.id.planAmount);
			tvPlanAmount.setText(strPlanAmount);
	
			// EBWFbgXV
			WidgetLogic logic = new WidgetLogic();
			logic.execute(this);
			
			manager.commit();
		} finally {
			manager.endTransaction();
			manager.close();
		}

		// ActivityĂяo
		Calendar cal = new GregorianCalendar();
		cal.setTime(adapter.getCurrentDate(viewPager.getCurrentItem()));
		callThisActivity(cal);

		Toast.makeText(this, "ڕWݒ肵܂B", Toast.LENGTH_LONG).show();
    }

    /**
     * JeS{^̏
     * @param view
     */
    public void onCategoryClick(View view) {
    	moveActivity(MonthlyCategoryActivity.class);
    }

    /**
     * `[g{^̏
     * @param view
     */
    public void onChartClick(View view) {
    	moveActivity(MonthlySummaryChartActivity.class, adapter.getCurrentDate(viewPager.getCurrentItem()));
    }

    /**
     * ReLXgj[
     */
    @SuppressWarnings("unchecked")
	public void onCreateContextMenu(ContextMenu menu, View view, ContextMenuInfo info) {
    	super.onCreateContextMenu(menu, view, info);
    	AdapterContextMenuInfo adapterInfo = (AdapterContextMenuInfo) info;
    	ListView listView = (ListView) view;
    	Map<String, Object> map = (Map<String, Object>) listView.getItemAtPosition(adapterInfo.position);

    	// wb_ݒ
    	menu.setHeaderTitle((String) map.get(BudgetTable.COLUMN_CONTENTS));
    	// j[ǉ
    	menu.add(0, 0, 0, "ҏW");
    	menu.add(1, 1, 1, "폜");
    }

    /**
     * ReLXgj[̏
     */
    @SuppressWarnings("unchecked")
	public boolean onContextItemSelected(final MenuItem item) {
    	// ItemID
    	int itemId = item.getItemId();

    	if (itemId == 0) {
    		// ҏW
	    	AdapterContextMenuInfo adapterInfo = (AdapterContextMenuInfo) item.getMenuInfo();
	    	Map<String, Object> map = (Map<String, Object>) detailListView.getItemAtPosition(adapterInfo.position);
	    	String txId = (String) map.get(BudgetTable.COLUMN_TX_ID);
	    	int amount = (Integer) map.get(BudgetTable.COLUMN_AMOUNT);
	    	String category = (String) map.get(BudgetTable.COLUMN_CATEGORY);
	    	String content = (String) map.get(BudgetTable.COLUMN_CONTENTS);
	    	String memo = (String) map.get(BudgetTable.COLUMN_MEMO);
	    	String txDate = (String) map.get(BudgetTable.COLUMN_TX_DATE);

	    	Intent intent = new Intent(this, RegistItem2Activity.class);
	    	intent.putExtra(BudgetTable.COLUMN_TX_ID, txId);
	    	intent.putExtra(BudgetTable.COLUMN_AMOUNT, amount);
	    	intent.putExtra(BudgetTable.COLUMN_CATEGORY, category);
	    	intent.putExtra(BudgetTable.COLUMN_CONTENTS, content);
	    	intent.putExtra(BudgetTable.COLUMN_MEMO, memo);
	    	intent.putExtra(BudgetTable.COLUMN_TX_DATE, txDate);
	    	moveActivity(intent);
    	} else if (itemId == 1) {
        	// 폜
        	AlertDialog.Builder builder = new AlertDialog.Builder(this);
        	builder.setTitle("mF");
        	builder.setMessage("{ɍ폜܂H");
        	builder.setPositiveButton("͂", new DialogInterface.OnClickListener() {
    			public void onClick(DialogInterface dialoginterface, int i) {
    				// 폜
    		    	AdapterContextMenuInfo adapterInfo = (AdapterContextMenuInfo) item.getMenuInfo();
    		    	Map<String, Object> map = (Map<String, Object>) detailListView.getItemAtPosition(adapterInfo.position);
    		    	String txId = (String) map.get(BudgetTable.COLUMN_TX_ID);

    		    	// ڍׂ̍폜
    		    	ConnectionManager manager = ConnectionManager.getInstance(DailySummaryActivity.this);
    		    	BudgetDao dao = new BudgetDao(manager);
    		    	
    		    	try {
	    		    	dao.deleteDetail(txId);
	
	    				// EBWFbgXV
	    		    	WidgetLogic logic = new WidgetLogic();
	    		    	logic.execute(DailySummaryActivity.this);
	
	    		    	// ʍĕ\
	    		    	Calendar cal = Calendar.getInstance();
	    		    	cal.setTime(adapter.getCurrentDate(viewPager.getCurrentItem()));
	    		    	callThisActivity(cal);
	    		    	manager.commit();
    		    	} finally {
    		    		manager.endTransaction();
    		    		manager.close();
    		    	}
    			}
    		});
        	builder.setNegativeButton("", new DialogInterface.OnClickListener() {
    			public void onClick(DialogInterface dialoginterface, int i) {
    				// Ȃ
    			}
    		});
        	builder.create().show();
    	}

    	return false;
    }
}
