package net.atlabo.money.activity;

import java.util.List;

import net.atlabo.money.R;
import net.atlabo.money.adapter.InputHistoryAdapter;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.dao.HistoryDao;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.os.Bundle;
import android.view.View;
import android.widget.ListView;
import android.widget.Toast;

/**
 * ͗̊Ǘ
 * @author Atsushi Nakamoto
 *
 */
public class InputHistoryConfigActivity extends Activity {
	private InputHistoryAdapter adapter;
	
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.input_history_config);
		
		// 擾
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setReadableDatabase();
		HistoryDao dao = new HistoryDao(manager);
		List<String> list = dao.selectWordList();
		manager.close();
		
		adapter = new InputHistoryAdapter(this, list);
		ListView listView = (ListView) findViewById(R.id.listView);
		listView.setAdapter(adapter);
	}
	
	/**
	 * I폜NbN
	 * @param view
	 */
	public void onDeleteHistoryClick(View view) {
		final List<String> list =  adapter.getCheckValue();

		if (list.isEmpty()) {
			// 1IĂȂꍇ
			Toast.makeText(this, "1IĂ܂B", Toast.LENGTH_SHORT).show();
			return;
		}
		
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setMessage("I폜܂B낵łH");
		builder.setPositiveButton("OK", new OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				// OKI폜
				ConnectionManager manager = ConnectionManager.getInstance(InputHistoryConfigActivity.this);
				manager.setWritableDatabase();
				HistoryDao dao = new HistoryDao(manager);
				try {
					for (String str : list) {
						dao.delete(str);
					}
					manager.commit();
				} finally {
					manager.endTransaction();
					manager.close();
				}
				Toast.makeText(InputHistoryConfigActivity.this, "I폜܂B", Toast.LENGTH_LONG).show();
				finish();
			}
		});
		builder.setNegativeButton("LZ", null);
		builder.create().show();
	}
	
	/**
	 * S폜{^NbN
	 * @param view
	 */
	public void onDeleteAllHistoryClick(View view) {
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setMessage("S폜܂B낵łH");
		builder.setNegativeButton("", null);
		builder.setPositiveButton("͂", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				// S폜
				ConnectionManager manager = ConnectionManager.getInstance(InputHistoryConfigActivity.this);
				manager.setWritableDatabase();
				HistoryDao dao = new HistoryDao(manager);
				try {
					dao.deleteAll();
					manager.commit();
				} finally {
					manager.endTransaction();
					manager.close();
				}
				Toast.makeText(InputHistoryConfigActivity.this, "̍폜܂B", Toast.LENGTH_LONG).show();
				
				finish();
			}
		});
		builder.create().show();
	}
}
