package net.atlabo.money.activity;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.adapter.CategoryAdapter;
import net.atlabo.money.adapter.HistoryAdapter;
import net.atlabo.money.component.HistoryTextView;
import net.atlabo.money.dao.BudgetCreditcardExtDao;
import net.atlabo.money.dao.BudgetDao;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.dao.HistoryDao;
import net.atlabo.money.db.table.BudgetCreditcardExtTable;
import net.atlabo.money.db.table.BudgetTable;
import net.atlabo.money.db.table.HistoryTable;
import net.atlabo.money.exception.SystemException;
import net.atlabo.money.logic.TwitterLogic;
import net.atlabo.money.logic.WidgetLogic;
import net.atlabo.money.util.ConfigUtil;
import net.atlabo.money.util.StringUtil;
import net.atlabo.money.webapi.iteminfo.Item;
import net.atlabo.money.webapi.iteminfo.ItemApi;
import net.atlabo.money.webapi.iteminfo.ItemInformationException;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnFocusChangeListener;
import android.view.WindowManager.LayoutParams;
import android.view.inputmethod.InputMethodManager;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TextView.OnEditorActionListener;
import android.widget.Toast;

public class RegistItem2Activity extends ExtendedActivity {
	private final static int REQUEST_GALLERY = 1;
	private final static int REQUEST_BARCODE = 2;

	private ImageView thumbImg;
	private Uri imageUri;

	// t͒l
	private TextView etInputDate = null;
	// e
	private HistoryTextView etContent = null;
	// 
	private EditText etMemo = null;
	// ee
	private EditText etText = null;
	// ttH[}bg
	private SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
	// ttH[}bg
	private SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");
	// z̓tB[h
	private EditText etInputAmount = null;
	private TextView tvInputAmount = null;
	// zo̓tB[h
	private LinearLayout textAmountField = null;
	// NWbgJ[h`FbN{bNX
	private CheckBox cbCredit = null;

	// twittertO
	private boolean twitterFlg = false;
	// facebooktO
	private boolean facebookFlg = false;

	// ҏWɎgpTX_ID
	private String txId;

	private DecimalFormat decimalF = new DecimalFormat("###,###,###");

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

		OnEditorActionListener listener = new OnEditorActionListener() {
			public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
				if(event.getKeyCode() == KeyEvent.KEYCODE_ENTER){
					hideSoftKeyboard(v);
				}
				return true;
			}
		};

		setContentView(R.layout.registitem2);

		// t擾
		etInputDate = (TextView) findViewById(R.id.date);
		// ݓtݒ肷
		etInputDate.setText(df.format(date));
		// z͒l擾
		tvInputAmount = (TextView) findViewById(R.id.amount);
		// z̓tB[h擾
		etInputAmount = (EditText) findViewById(R.id.inputAmount);
		etInputAmount.setOnFocusChangeListener(new OnFocusChangeListener() {

			public void onFocusChange(View v, boolean hasFocus) {
				if (!hasFocus) {
					hideSoftKeyboard(v);
					reflectAmount(1);
					etInputAmount.setVisibility(View.GONE);
					textAmountField.setVisibility(View.VISIBLE);
				}
			}
		});
		// zeLXgtB[h擾
		textAmountField = (LinearLayout) findViewById(R.id.textAmountField);
		this.onAmountClick(textAmountField);
		// e擾
		etContent = ((HistoryTextView) findViewById(R.id.content));
		etContent.setOnEditorActionListener(listener);
		updateTags(); // TODO
		etContent.setOnFocusChangeListener(new OnFocusChangeListener() {

			public void onFocusChange(View v, boolean hasFocus) {
				if (!hasFocus) {
					hideSoftKeyboard(v);
				}
			}
		});

		// 擾
		etMemo =  ((EditText)findViewById(R.id.memo));
		etMemo.setOnEditorActionListener(listener);
		etMemo.setOnFocusChangeListener(new OnFocusChangeListener() {

			public void onFocusChange(View v, boolean hasFocus) {
				if (!hasFocus) {
					hideSoftKeyboard(v);
				}
			}
		});
		
		// NWbgJ[h`FbN{bNX擾
		cbCredit = (CheckBox) findViewById(R.id.checkCredit);

		// JeSݒ肷
		Spinner categorySpinner = (Spinner) findViewById(R.id.category);
		categorySpinner.setPrompt("JeSI");
		CategoryAdapter adapter = new CategoryAdapter(this);
		categorySpinner.setAdapter(adapter);

		// ҏW[hǂf
		Intent intent = getIntent();
		String txId = intent.getStringExtra(BudgetTable.COLUMN_TX_ID);
		if (txId != null) {
			// TX_ID݂ꍇ͕ҏW[h

			// \ݒ肷
			initEdit();

			View registView =  findViewById(R.id.menu_regist);
			registView.setVisibility(View.GONE);

			View updateView = findViewById(R.id.menu_update);
			updateView.setVisibility(View.VISIBLE);
		}
	}

	private void initEdit() {
		Intent intent = getIntent();

		// TX_IDݒ肷
		txId = intent.getStringExtra(BudgetTable.COLUMN_TX_ID);

		String strDate = intent.getStringExtra(BudgetTable.COLUMN_TX_DATE);
		try {
			date = df2.parse(strDate);
		} catch (ParseException e) {
			throw new SystemException("t̃tH[}bgɎs܂B", e);
		}

		// ݓtݒ肷
		etInputDate.setText(df.format(date));
		// zݒ肷
		int amount = intent.getIntExtra(BudgetTable.COLUMN_AMOUNT, 0);
		tvInputAmount.setText(decimalF.format(amount));
		onAmountClick(textAmountField);
		// eݒ肷
		String strContent = intent.getStringExtra(BudgetTable.COLUMN_CONTENTS);
		etContent.setText(strContent);
		// ݒ肷
		String strMemo = intent.getStringExtra(BudgetTable.COLUMN_MEMO);
		etMemo.setText(strMemo);
		// JeSݒ肷
		String strCategory = intent.getStringExtra(BudgetTable.COLUMN_CATEGORY);
		Spinner categorySpinner = (Spinner) findViewById(R.id.category);
		CategoryAdapter adapter = (CategoryAdapter) categorySpinner.getAdapter();
		categorySpinner.setSelection(adapter.getPosition(strCategory));
		// `FbN{bNXݒ肷
		// Xe[^XNULLłȂ΃`FbN
		String status = intent.getStringExtra(BudgetCreditcardExtTable.COLUMN_STATUS);
		if (status != null) {
			cbCredit.setChecked(true);
		}
	}

	/**
	 * \tgL[{[hB
	 */
	private void hideSoftKeyboard(View v) {
		InputMethodManager imm = (InputMethodManager)getSystemService(INPUT_METHOD_SERVICE);
		imm.hideSoftInputFromWindow(v.getWindowToken(), InputMethodManager.HIDE_IMPLICIT_ONLY);
		imm.hideSoftInputFromWindow(v.getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);
	}

	/**
	 * ttB[hɓ삷
	 * @param view
	 */
	public void onDateClick(View view) {
		final Calendar calendar = Calendar.getInstance();
		try {
			calendar.setTime(df.parse(etInputDate.getText().toString()));
		} catch (ParseException e) {
			throw new SystemException("t̃tH[}bgɎs܂B", e);
		}
		final int year = calendar.get(Calendar.YEAR);
		final int month = calendar.get(Calendar.MONTH);
		final int day = calendar.get(Calendar.DAY_OF_MONTH);

		// DatePickerDialog𐶐
		// TODO ̂Ƃ̕\ςȂłǁEEEEEB
		DatePickerDialog dialog = new DatePickerDialog(this,
				new DatePickerDialog.OnDateSetListener() {
					// tݒ肳ꂽꍇ̏
					public void onDateSet(DatePicker view, int year, int monthOfYear,
							int dayOfMonth) {
						monthOfYear++;
						// tݒ莞̏
						etInputDate.setText(year + "/"
								+ StringUtil.leftpadZero(Integer.toString(monthOfYear), 2) + "/"
								+ StringUtil.leftpadZero(Integer.toString(dayOfMonth), 2));
					}
				}, year, month, day);
		dialog.setTitle("t");
		dialog.show();
	}

	/**
	 * o^{^̏
	 * @param view
	 */
	public void onRegistClick(final View view) {
		// ̓`FbN{
		if (!inputCheck()) {
			return;
		}
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		LayoutInflater inflater = LayoutInflater.from(this);
		LinearLayout dialogLayout = (LinearLayout) inflater.inflate(R.layout.regist_dialog, null);
		etText = (EditText) dialogLayout.findViewById(R.id.textField);
		builder.setView(dialogLayout);
//		builder.setMessage("o^܂B낵łH");
		builder.setPositiveButton("͂", new DialogInterface.OnClickListener() {

			public void onClick(DialogInterface dialog, int which) {
				// ͓eo^
				boolean ret = regist(0);
				if (!ret) {
					return;
				}

				// o^
				registHistory();

				// EBWFbgXV
				WidgetLogic logic = new WidgetLogic();
				logic.execute(RegistItem2Activity.this);
				// o^ɐActivityI
				finish();
			}
		});
		builder.setNegativeButton("", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				// Ȃ
			}
		});
		builder.create().show();
	}

	/**
	 * XV{^̏
	 * @param view
	 */
	public void onUpdateClick(final View view) {
		// ̓`FbN{
		if (!inputCheck()) {
			return;
		}
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setMessage("XV܂B낵łH");
		builder.setPositiveButton("͂", new DialogInterface.OnClickListener() {

			public void onClick(DialogInterface dialog, int which) {
				// ͓eōXV
				boolean ret = regist(1);
				if (!ret) {
					return;
				}
				// EBWFbgXV
				WidgetLogic logic = new WidgetLogic();
				logic.execute(RegistItem2Activity.this);
				// o^ɐActivityI
				finish();
			}
		});
		builder.setNegativeButton("", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				// Ȃ
			}
		});
		builder.create().show();
	}

	/**
	 * o^
	 * ̏ꍇtrueԋp
	 * ̓G[̏ꍇfalseԋp
	 */
	private boolean regist(int mode) {

		reflectAmount(1);

		// t擾
		String date = ((TextView)findViewById(R.id.date)).getText().toString();
		// z擾
		final String amount = tvInputAmount.getText().toString();
		// e擾
		final String contents = etContent.getText().toString();
		// JeS擾
		Spinner categorySpinner = (Spinner) findViewById(R.id.category);
		Map<String, Object> categoryMap = (Map<String, Object>) categorySpinner.getSelectedItem();
		String category = (String) categoryMap.get("NAME");
		// 擾
		String memo = etMemo.getText().toString();
		// NWbgJ[hŎx擾
		boolean isChecked = cbCredit.isChecked();

		if (twitterFlg) {
			// Twitterɓe
			Log.v("twitter", "Twitter Handler recceived!!");
			TwitterLogic logic = new TwitterLogic(RegistItem2Activity.this);
			boolean ret = logic.tweet(contents + "" + amount + "o܂B #VbsmLN");
			if (!ret) {
				return false;
			}
		}

		if (facebookFlg) {
			// facebookɓe
			Log.v("facebook", "facebookɓeJn");
			Intent intent = new Intent(this, FBPostActivity.class);
			intent.putExtra("text", etText.getText().toString());
			intent.putExtra("content", etContent.getText().toString());
			intent.putExtra("imageUri", imageUri);
			intent.putExtra("inputAmount", tvInputAmount.getText().toString());
			startActivity(intent);
		}

		int iamount = Integer.parseInt(amount.replaceAll(",", "").replaceAll("~", ""));

		Map<String, Object> map = new HashMap<String, Object>();
		// TX_ID̓^CX^v
		map.put(BudgetTable.COLUMN_TX_ID ,Long.toString(new Date().getTime()));
		map.put(BudgetTable.COLUMN_TX_DATE, date.replaceAll("/", ""));
		map.put(BudgetTable.COLUMN_AMOUNT, iamount);
		map.put(BudgetTable.COLUMN_CONTENTS, contents);
		map.put(BudgetTable.COLUMN_CATEGORY, category);
		map.put(BudgetTable.COLUMN_MEMO, memo);
		
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setWritableDatabase();

		BudgetDao dao = new BudgetDao(manager);
		BudgetCreditcardExtDao dao2 = new BudgetCreditcardExtDao(manager);
		
		try {
			if (mode == 0) {
				// o^
					dao.insertBudget(map);
					if (isChecked) {
						// NJ`FbN̏ꍇAe[uݒ
						dao2.insertBudget(map);
					}
					manager.commit();
	
				Toast.makeText(this, "o^܂B", Toast.LENGTH_LONG).show();
			} else if (mode == 1) {
				// XV
				map.put(BudgetTable.COLUMN_TX_ID , txId);
				dao.updateBudget(map);
				
				// NJe[ǔ
				if (dao2.select(txId) == null) {
					// R[hȂꍇ̂ݍXV
					if (isChecked) {
						// NJe[uɓo^
						dao2.insertBudget(map);
					}
				} else {
					// R[hA`FbNȂꍇ͍폜
					if (!isChecked) {
						// NJe[u폜
						dao2.deleteDetail(txId);
					}
				}
								
				manager.commit();
				Toast.makeText(this, "XV܂B", Toast.LENGTH_LONG).show();
			}
		} finally {
			manager.endTransaction();
			manager.close();
		}

		return true;
	}

	/**
	 * ̓`FbN{
	 * @return
	 */
	private boolean inputCheck() {
		// t擾
		String date = ((TextView)findViewById(R.id.date)).getText().toString();
		// z擾
		final String amount = tvInputAmount.getText().toString();
		// e擾
		final String contents = etContent.getText().toString();
		// JeS擾
		Spinner categorySpinner = (Spinner) findViewById(R.id.category);
		Map<String, Object> categoryMap = (Map<String, Object>) categorySpinner.getSelectedItem();
		String category = (String) categoryMap.get("NAME");
		// 擾
		String memo = etMemo.getText().toString();

		// ̓`FbN
		if ("".equals(date)) {
			Toast.makeText(this, "tݒ肳Ă܂B", Toast.LENGTH_LONG).show();
			return false;
		}

		if ("".equals(amount) || "0".equals(amount)) {
			Toast.makeText(this, "zݒ肳Ă܂B", Toast.LENGTH_LONG).show();
			return false;
		}

		if ("".equals(contents)) {
			Toast.makeText(this, "eݒ肳Ă܂B", Toast.LENGTH_LONG).show();
			return false;
		}

		if (category == null || "".equals(category)) {
			Toast.makeText(this, "JeSIĂ܂B", Toast.LENGTH_LONG).show();
			return false;
		}

		return true;
	}

	/**
	 * o^
	 * ͐ݒ肵ȊO͓ťÂ̂폜B
	 * ̒ɂ̂ɂĂ͍폜ēo^邱ƂœeŐVɕۂ
	 * @param categoryId
	 * @param word
	 */
	private void registHistory() {
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setWritableDatabase();
		HistoryDao dao = new HistoryDao(manager);

		try {
			int count = dao.count();
	
			// TODO ͂Ƃ肠100Ƃ
			if (count >= 100) {
				// 폜
				dao.deleteLast();
			}
	
			Map<String, Object> map = new HashMap<String, Object>();
			int cur = (int) System.currentTimeMillis() / 1000;
			String word = etContent.getText().toString();
			Spinner categorySpinner = (Spinner) findViewById(R.id.category);
			Map<String, Object> categoryMap = (Map<String, Object>) categorySpinner.getSelectedItem();
			int rid = (Integer) categoryMap.get("RESOURCE_ID");
	
			map.put(HistoryTable.COLUMN_REGIST_DATE, cur);
			map.put(HistoryTable.COLUMN_CATEGORY_ID, Integer.toString(rid));
			map.put(HistoryTable.COLUMN_WORD, word);
	
			// d΍폜
			dao.delete(word);
			// o^
			dao.insert(map);
			
			// R~bg
			manager.commit();
		} finally {
			manager.endTransaction();
			manager.close();
		}
	}

	/**
	 * twitter{^̏
	 * @param view
	 */
	public void onTwitterClick(View view) {
		ImageView imageView = (ImageView) view;

		// ݒ󋵂mF
		if (!ConfigUtil.isRegistedTwitter(this)) {
			// ݒȂ̏ꍇToasto͂ďI
			Toast.makeText(this, "Twitter̐ݒsĂ܂BݒTwitterݒsĂB",
					Toast.LENGTH_SHORT).show();
			return;
		}

		if (!twitterFlg) {
			// onɉ摜ύX
			imageView.setImageResource(R.drawable.button_twitter);
			// flag𔽓]
			twitterFlg = true;
		} else {
			// offɉ摜ύX
			imageView.setImageResource(R.drawable.button_twitter_no);
			// flag𔽓]
			twitterFlg = false;
		}
	}

	/**
	 * facebook{^̏
	 * @param view
	 */
	public void onFacebookClick(View view) {
		ImageView imageView = (ImageView) view;

		// ݒ󋵂mF
		if (!ConfigUtil.isRegistedFacebook(this)) {
			// ݒȂ̏ꍇToasto͂ďI
			Toast.makeText(this, "facebook̐ݒsĂ܂BݒfacebookݒsĂB",
					Toast.LENGTH_SHORT).show();
			return;
		}

		if (!facebookFlg) {
			// onɉ摜ύX
			imageView.setImageResource(R.drawable.button_facebook);
			// flag𔽓]
			facebookFlg = true;
		} else {
			// offɉ摜ύX
			imageView.setImageResource(R.drawable.button_facebook_no);
			// flag𔽓]
			facebookFlg = false;
		}
	}

	/**
	 * zNbN̏
	 * @param view
	 */
	public void onAmountClick(View view) {
		Log.v("money", "onAmountClick!!!");

		reflectAmount(0);
		etInputAmount.setVisibility(View.VISIBLE);
		// tH[JXݒ
		etInputAmount.requestFocus();
		// eLXgʒuݒ
		etInputAmount.setSelection(etInputAmount.getText().length());
		InputMethodManager manager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
		manager.showSoftInput(etInputAmount, InputMethodManager.SHOW_IMPLICIT);
		view.setVisibility(View.GONE);
	}

	/**
	 * M[Ăяo
	 * @param view
	 */
	public void onGalleryClick(View view) {
		thumbImg = (ImageView) view;

		Intent intent = new Intent();
		intent.setType("image/*");
		intent.setAction(Intent.ACTION_GET_CONTENT);
		// ͖߂ĂƂ̔ʗp̓Kint
		startActivityForResult(intent, REQUEST_GALLERY);
	}


	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
	    if (resultCode == RESULT_OK && requestCode == REQUEST_GALLERY) {
	    	// M[̏ꍇ
	        try{
	        	imageUri = data.getData();
	            InputStream is = getContentResolver().openInputStream(imageUri);
	            Bitmap bm = BitmapFactory.decodeStream(is);
	            is.close();

	            thumbImg.setImageBitmap(bm);
	        }catch(Exception e){
	        	Log.e("gallery", "M[摜擾ŃG[", e);
	        }
	    } else if (resultCode == RESULT_OK && requestCode == REQUEST_BARCODE){
	    	// o[R[h̏ꍇ
			final String barcode = data.getStringExtra("SCAN_RESULT");

			// 
			final ItemApi itemApi = new ItemApi(this);
			Item item;
			try {
				item = itemApi.selectItem(barcode);
			} catch (Exception e) {
				Toast.makeText(this, "o[R[h擾Ɏs܂B", Toast.LENGTH_SHORT).show();
				return;
			}

			if (item == null) {
				Log.v("barcode", "R[h݂ȂB");
				// ݂Ȃꍇ
				LayoutInflater inflater = LayoutInflater.from(this);
				final View view = inflater.inflate(R.layout.item_regist_dialog, null);
				AlertDialog.Builder builder = new AlertDialog.Builder(this);
				builder.setView(view);
				builder.setNegativeButton("LZ", null);
				builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {

					public void onClick(DialogInterface dialog, int which) {
						EditText etRegistItemName = (EditText) view.findViewById(R.id.registItemTextField);
						String itemName = etRegistItemName.getText().toString();
						if ("".equals(itemName)) {
							Toast.makeText(RegistItem2Activity.this, "i͂ĂB", Toast.LENGTH_SHORT);
							return;
						}
						Item item = new Item();
						item.setCode(barcode);
						item.setItemName(itemName);
						try {
							itemApi.registItem(item);
							etContent.setText(itemName);
						} catch (ItemInformationException e) {
							Toast.makeText(RegistItem2Activity.this, "o[R[ho^Ɏs܂B", Toast.LENGTH_SHORT).show();
							return;
						}
					}
				});
				builder.create().show();
			} else {
				Log.v("barcode", "R[h݂B[" + item.getItemName() + "]");
				// ݂ꍇ
				etContent.setText(item.getItemName());
			}
	    }
	}

	/**
	 * o[R[h{^
	 * @param view
	 */
	public void onBarcodeClick(View view) {
		Intent intent = new Intent("com.google.zxing.client.android.SCAN");
		intent.putExtra("SCAN_MODE", "ONE_D_MODE");

		try {
			startActivityForResult(intent, REQUEST_BARCODE);
		} catch (ActivityNotFoundException e) {
			new AlertDialog.Builder(this)
					.setTitle("QR Scaner not found.")
					.setMessage("o[R[h̃XLɂQRR[hXLi[KvłB_E[h܂H")
					.setPositiveButton("͂", new OnClickListener() {
						public void onClick(DialogInterface dialog, int which) {
							Uri uri = Uri.parse("market://search?q=com.google.zxing.client.android");
							Intent intent = new Intent(Intent.ACTION_VIEW, uri);
							try {
								startActivity(intent);
							} catch (ActivityNotFoundException e) {
								new AlertDialog.Builder(RegistItem2Activity.this)
									.setTitle("x")
									.setMessage("QRR[hXLi[_E[hł܂B")
									.setPositiveButton("OK", null)
									.show();
							}
						}
					})
					.setNegativeButton("", null).show();


		}
	}

	/**
	 * z𔽉f
	 * Emode=0̏ꍇ
	 * @tvInputAmountetInputAmount
	 * Emode=1̏ꍇ
	 * @etInputAmounttvInputAmount
	 */
	private void reflectAmount(int mode) {
		if (mode == 0) {
			String strAmount = tvInputAmount.getText().toString();
			strAmount = strAmount.replaceAll(",", "");

			if ("0".equals(strAmount)) {
				strAmount = "";
			}
			etInputAmount.setText(strAmount);
		} else if (mode == 1) {
			String strAmount = etInputAmount.getText().toString();
			if ("".endsWith(strAmount)) {
				strAmount = "0";
			}
			strAmount = decimalF.format(Integer.parseInt(strAmount));
			tvInputAmount.setText(strAmount);
		}
	}

	private void updateTags() {
		// 擾
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setReadableDatabase();
		HistoryDao dao = new HistoryDao(manager);
		List<String> list = dao.selectWordList();
		manager.close();
		HistoryAdapter adapter = new HistoryAdapter(this, list);
		etContent.setAdapter(adapter);
	}

	/**
	 * IvVj[̐
	 */
    public boolean onCreateOptionsMenu(Menu menu) {

        menu.add(1, 1, 1, "ݒ").setIcon(android.R.drawable.ic_menu_manage);

        return true;
    }

    /**
     * IvVj[̑I
     */
    public boolean onOptionsItemSelected(MenuItem item) {
    	if (item.getItemId() == 1) {
    		// ݒ{^̏
    		Intent intent = new Intent(this, ConfigActivity.class);
    		startActivity(intent);
    	}

    	return true;
    }

}
