package net.atlabo.money.adapter;

import java.util.ArrayList;
import java.util.List;

import net.atlabo.money.R;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.TextView;

public class InputHistoryAdapter extends ArrayAdapter<String> {
	private LayoutInflater inflater;

	private List<Boolean> checkList;

	public InputHistoryAdapter(Context context, List<String> objects) {
		super(context, 0, objects);

		checkList = new ArrayList<Boolean>();
		inflater = LayoutInflater.from(context);

		for (String str : objects) {
			checkList.add(false);
		}
	}

	public View getView(final int position, View convertView, ViewGroup parent) {
		Log.v("InputHistoryAdapter", "getView : " + position);
		if (convertView == null) {
			convertView = inflater.inflate(R.layout.input_history_list_item,
					null);
		}

		TextView tv = (TextView) convertView.findViewById(R.id.text1);
		tv.setText(getItem(position));

		CheckBox checkbox = (CheckBox) convertView.findViewById(R.id.checkbox);
		checkbox.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView,
					boolean isChecked) {
				checkList.set(position, isChecked);
			}
		});

		return convertView;
	}

	/**
	 * `FbNꂽl擾
	 * 
	 * @return
	 */
	public List<String> getCheckValue() {
		ArrayList<String> retList = new ArrayList<String>();
		for (int i=0, size=checkList.size(); i<size; i++) {
			Boolean b = checkList.get(i);
			if (b) {
				retList.add(getItem(i));
			}
		}
		
		return retList;
	}
}
