package net.atlabo.money.component;

import java.text.DecimalFormat;

import net.atlabo.money.R;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class AmountInputDialog {
	// ző包
	// TODO Ƃ肠9ȁEEEE
	private static final int MAX_LENGTH_MONEY = 9;
	public static final String STR_AMOUNT = "STR_AMOUNT";
	public static final int CLICK_OK = 1;

	private DecimalFormat decimalF;

	private Context context;
	private String strAmount = "";
	private String title;
	private Handler handler;

	private TextView tvInputAmount;

	public AmountInputDialog(Context context, Handler handler) {
		this.context = context;
		this.handler = handler;
		decimalF = new DecimalFormat("###,###,###~");
	}

	public AmountInputDialog setStrAmount(String amount) {
		this.strAmount = amount;
		return this;
	}

	public AmountInputDialog setTitle(String title) {
		this.title = title;
		return this;
	}

	public void showDialog(Integer planAmount) {
		LayoutInflater inflater = LayoutInflater.from(context);
		View dialogView = inflater.inflate(R.layout.amountinputdialog2, null);

		// lݒ
		if (planAmount != null) {
			strAmount = Integer.toString(planAmount);
		} else {
			strAmount = "0";
		}


		// z擾
		tvInputAmount = (TextView) dialogView.findViewById(R.id.amount);
		tvInputAmount.setText(decimalF.format(Integer.parseInt(strAmount)));

		// {^ɃXiݒ
		setOnClickListener(dialogView);

		AlertDialog.Builder builder = new AlertDialog.Builder(context);
		builder.setView(dialogView);
		builder.setNegativeButton("߂", new DialogInterface.OnClickListener(){
			public void onClick(DialogInterface dialog, int which) {
				// TODO ꂽ\bhEX^u

			}
		});
		builder.setPositiveButton("m", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				Message msg = new Message();
				Bundle b = new Bundle();
				b.putString(STR_AMOUNT, decimalF.format(Integer.parseInt(strAmount)));
				msg.setData(b);
				msg.what = CLICK_OK;
				handler.sendMessage(msg);
				dialog.cancel();
			}
		});

		// titleݒ肳ĂꍇAbuilderɐݒ肷
		if (title != null) {
			builder.setTitle(title);
		}
		builder.create().show();
	}

	private void setTvInputAmount() {
		tvInputAmount.setText(decimalF.format(Integer.parseInt(strAmount)));
	}

	/* ========================================================
	 * ȉ͋z_CAO̊e{^̏Lq
	 * 
	 * ========================================================*/

	private void setOnClickListener(View view) {
		Button buttonZero = (Button) view.findViewById(R.id.zero);
		buttonZero.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onZeroClick(view);
			}
		});

		Button buttonOne = (Button) view.findViewById(R.id.one);
		buttonOne.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onOneClick(view);
			}
		});

		Button buttonTwo = (Button) view.findViewById(R.id.two);
		buttonTwo.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onTwoClick(view);
			}
		});

		Button buttonThree = (Button) view.findViewById(R.id.three);
		buttonThree.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onThreeClick(view);
			}
		});

		Button buttonFour = (Button) view.findViewById(R.id.four);
		buttonFour.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onFourClick(view);
			}
		});

		Button buttonFive = (Button) view.findViewById(R.id.five);
		buttonFive.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onFiveClick(view);
			}
		});

		Button buttonSix = (Button) view.findViewById(R.id.six);
		buttonSix.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onSixClick(view);
			}
		});

		Button buttonSeven = (Button) view.findViewById(R.id.seven);
		buttonSeven.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onSevenClick(view);
			}
		});

		Button buttonEight = (Button) view.findViewById(R.id.eight);
		buttonEight.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onEightClick(view);
			}
		});

		Button buttonNine = (Button) view.findViewById(R.id.nine);
		buttonNine.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onNineClick(view);
			}
		});

		Button buttonClear = (Button) view.findViewById(R.id.clear);
		buttonClear.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onClearClick(view);
			}
		});

		Button buttonBack = (Button) view.findViewById(R.id.back);
		buttonBack.setOnClickListener(new View.OnClickListener() {
			public void onClick(View view) {
				onBackClick(view);
			}
		});
	}

	/**
	 * 0̏
	 */
	public void onZeroClick(View view) {
		if ("".equals(strAmount)) {
			// 󕶎̏ꍇ͉ɏI
			return;
		}

		addstrAmount("0");
	}

	/**
	 * 1̏
	 */
	public void onOneClick(View view) {
		addstrAmount("1");
	}
	/**
	 * 2̏
	 */
	public void onTwoClick(View view) {
		addstrAmount("2");
	}
	/**
	 * 3̏
	 */
	public void onThreeClick(View view) {
		addstrAmount("3");
	}
	/**
	 * 4̏
	 */
	public void onFourClick(View view) {
		addstrAmount("4");
	}
	/**
	 * 5̏
	 */
	public void onFiveClick(View view) {
		addstrAmount("5");
	}
	/**
	 * 6̏
	 */
	public void onSixClick(View view) {
		addstrAmount("6");
	}
	/**
	 * 7̏
	 */
	public void onSevenClick(View view) {
		addstrAmount("7");
	}
	/**
	 * 8̏
	 */
	public void onEightClick(View view) {
		addstrAmount("8");
	}
	/**
	 * 9̏
	 */
	public void onNineClick(View view) {
		addstrAmount("9");
	}
	/**
	 * C̏
	 */
	public void onClearClick(View view) {
		// zNA
		strAmount = "0";
		// zXV
		setTvInputAmount();
	}
	/**
	 * +̏
	 */
	public void onPlusClick(View view) {
		if (strAmount.startsWith("+")) {
			// u+vŎn܂ꍇ͍폜A1̏ꍇ͋󕶎
			if (strAmount.length() == 1) {
				strAmount = "";
			} else {
				strAmount = strAmount.substring(1);
			}
		} else {
			// u+vŎn܂Ȃꍇ́u+vǉ
			strAmount = "+" + strAmount;
		}

		// zXV
		setTvInputAmount();
	}
	/**
	 * ̏
	 */
	public void onBackClick(View view) {
		// 󕶎̏ꍇȂ
		if ("".equals(strAmount)) {
			return;
		}

		// Ō1폜
		strAmount = strAmount.substring(0 ,strAmount.length()-1);

		if (strAmount.length() == 0) {
			strAmount = "0";
		}
		// zXV
		setTvInputAmount();
	}

	/**
	 * ǉB
	 * AőTCYȏɂ͂Ȃ
	 * @param str
	 */
	public void addstrAmount(String str) {
		// ő包
		int maxLength = MAX_LENGTH_MONEY;
		if (strAmount.startsWith("+")) {
			// u+vŎn܂ꍇAŒ1₷
			maxLength += 1;
		}

		if (strAmount.length() >= maxLength) {
			// ő包ɒBĂꍇ͉Ȃ
			return;
		}

		if ("0".equals(strAmount)) {
			// 0̏ꍇstr̂܂ܐݒ肷
			strAmount = str;
		} else {
			// 
			strAmount += str;
		}
		// tvInputAmountXV
		setTvInputAmount();
	}

	/* ========================================================
	 * 
	 * z_CAO̊e{^̏Lq܂
	 * ========================================================*/
}
