package net.atlabo.money.component;

import org.afree.chart.AFreeChart;
import org.afree.graphics.geom.RectShape;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;

public class SamplePieChartView extends View {
    private AFreeChart chart;

    public SamplePieChartView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        // ʂ̏cATCY̏ɍ킹B
        WindowManager manager = (WindowManager) super.getContext().getSystemService(Context.WINDOW_SERVICE);
        Display d = manager.getDefaultDisplay();
        int width = d.getWidth();
        int height = d.getHeight();

        int i = 0;
        if (width > height) {
        	i = height;
        } else {
        	i = width;
        }

        RectShape chartArea = new RectShape(0.0, 0.0, i, i);
        this.chart.draw(canvas, chartArea);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    public void setChart(AFreeChart chart) {
        this.chart = chart;
    }
}
