package net.atlabo.money.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.atlabo.money.db.table.HistoryTable;
import android.database.sqlite.SQLiteCursor;

public class HistoryDao extends BaseDao {

	public HistoryDao(ConnectionManager manager) {
		super(manager);
	}

	public void insert(Map<String, Object> map) {
		String sql = "insert into HISTORY ("
				+ "REGIST_DATE, "
				+ "CATEGORY_ID, "
				+ "WORD"
			+ ") values ("
				+ "?, "
				+ "?, "
				+ "?) ";

			manager.insert(sql, new Object[]{
					map.get(HistoryTable.COLUMN_REGIST_DATE),
					map.get(HistoryTable.COLUMN_CATEGORY_ID),
					map.get(HistoryTable.COLUMN_WORD)
			});
	}

	public void delete(String word) {
		String sql = "delete from HISTORY where WORD = ?";
		manager.delete(sql, new Object[]{word});
	}

	public void deleteAll() {
		String sql = "delete from HISTORY";
		manager.delete(sql);
	}

	public void deleteLast() {
		List<Map<String, Object>> list = selectList();

		if (list.isEmpty()) {
			return;
		}
		
		delete((String) list.get(list.size() - 1).get(HistoryTable.COLUMN_WORD));
	}

	public List<Map<String, Object>> selectList() {
		String sql = "select REGIST_DATE, CATEGORY_ID, WORD from HISTORY "
				+ "order by REGIST_DATE desc";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, null);
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		Map<String, Object> map = null;
		while (c.moveToNext()) {
			map = new HashMap<String, Object>();
			map.put(HistoryTable.COLUMN_REGIST_DATE, c.getInt(0));
			map.put(HistoryTable.COLUMN_CATEGORY_ID, c.getString(1));
			map.put(HistoryTable.COLUMN_WORD, c.getString(2));
			list.add(map);
		}

		c.close();
		return list;
	}

	public List<String> selectWordList() {
		String sql = "select WORD from HISTORY "
				+ "order by REGIST_DATE desc";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, null);
		List<String> list = new ArrayList<String>();
		while (c.moveToNext()) {
			list.add(c.getString(0));
		}

		c.close();
		return list;
	}

	public List<String> selectList(String category) {
		String sql = "select WORD from HISTORY "
				+ "where CATEGORY_ID = ? order by REGIST_DATE desc";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{category});
		List<String> list = new ArrayList<String>();
		while (c.moveToNext()) {
			list.add(c.getString(0));
		}

		c.close();
		return list;
	}

	public int count() {
		String sql = "select count(*) from HISTORY ";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, null);
		int count = 0;
		if(c.moveToNext()) {
			count = c.getInt(0);
		}

		c.close();
		return count;
	}

}
