package net.atlabo.money.db.helper;

import net.atlabo.money.R;
import net.atlabo.money.db.table.TableManager;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

/**
 *
 * DBHelperNX
 * @author Atsushi Nakamoto
 */
public class DBOpenHelperManager {
	// o[W
	public int version;
	// DB
	public String dbName;
	// TableManagerNX̃IuWFNg
	private TableManager manager;

	/**
	 * RXgN^͎g킹Ȃ
	 */
	private DBOpenHelperManager() {
	}

	/**
	 * RXgN^
	 * @param context
	 */
	private DBOpenHelperManager(Context context) {
		version = Integer.parseInt(context.getString(R.string.db_version));
		dbName = context.getString(R.string.db_name);
	}

	/**
	 * DBOpenHelperNX̃CX^X𐶐
	 * @param context
	 * @return
	 */
	public static DBOpenHelper getInstance(Context context) {
		DBOpenHelperManager self = new DBOpenHelperManager(context);
		return self.new DBOpenHelper(context, self.dbName, self.version);
	}

	/**
	 * DB𑀍삷NX
	 * @author Atsushi Nakamoto
	 *
	 */
	public class DBOpenHelper extends SQLiteOpenHelper {

		private DBOpenHelper(Context context, String dbName, int version) {
			super(context, dbName, null, version);
			manager = new TableManager(context);
		}

		/**
		 * ɌĂяoB
		 */
		@Override
		public void onCreate(SQLiteDatabase db) {
			// gUNVJn
			db.beginTransaction();

			try {
				// e[u쐬
				manager.createTable(db);

				// R~bgs
				db.setTransactionSuccessful();
			} finally {
				// gUNVI
				db.endTransaction();
			}
		}

		/**
		 * o[WςꍇɌĂяo
		 */
		@Override
		public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
			// gUNVJn
			db.beginTransaction();

			try {
				// e[uXV
				manager.updateTable(db, oldVersion, newVersion);

				// R~bgs
				db.setTransactionSuccessful();
			} finally {
				// gUNVI
				db.endTransaction();
			}
		}

	}


}
