package net.atlabo.money.db.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import android.content.Context;

public abstract class AbstractTable {
	public static enum ColumnType {TEXT, INTEGER, REAL, BLOB};
	public static enum ConstraintType {PRIMARY_KEY, UNIQUE, NOT_NULL;
		public String toString() {
			return name().replaceAll("_", " ");
		}
	};
	public abstract String getStatementOnCreate();
	public abstract String[] getStatementOnUpdate(int oldVersion, int newVersion);
	protected Context context;


	/**
	 * CREATE TABLE𐶐NX
	 * TODO ̂MODIFY TABLE쐬
	 * @author Atsushi Nakamoto
	 *
	 */
	public class SQLCreator {
		/** e[u */
		private String tableName;
		/** JXg */
		private List<Column> columnList;
		/** 񃊃Xg */
		private List<Constraint> constraintList;

		/**
		 * RXgN^
		 */
		public SQLCreator() {
			columnList = new ArrayList<Column>();
			constraintList = new ArrayList<Constraint>();
		}

		/**
		 * e[uݒ肷
		 * @param tableName
		 * @return
		 */
		public SQLCreator setTableName(String tableName) {
			this.tableName = tableName;
			return this;
		}

		/**
		 * Jǉ
		 * @param columnName
		 * @param columnType
		 * @return
		 */
		public SQLCreator addColumn(String columnName, ColumnType columnType) {
			Column column = new Column();
			column.columnName = columnName;
			column.columnType = columnType;
			return addColumn(column);
		}

		/**
		 * Jǉ
		 * @param column
		 * @return
		 */
		public SQLCreator addColumn(Column column) {
			columnList.add(column);
			return this;
		}

		/**
		 * ǉ
		 * @param columnName
		 * @param constraintType
		 * @return
		 */
		public SQLCreator addConstraint(String columnName, ConstraintType constraintType) {
			Constraint constraint = new Constraint();
			constraint.columnName = columnName;
			constraint.constraintType = constraintType;
			return addConstraint(constraint);
		}

		/**
		 * ǉ
		 * @param constraint
		 * @return
		 */
		public SQLCreator addConstraint(Constraint constraint) {
			constraintList.add(constraint);
			return this;
		}

		/**
		 * SQL𐶐
		 * @return
		 */
		public String createSQL() {
			StringBuffer sb = new StringBuffer();
			sb.append("create table ").append(tableName).append(" (");

			/*
			 * Jݒ
			 */
			Iterator<Column> it1 = columnList.iterator();
			Column column;
			while (it1.hasNext()) {
				column = it1.next();
				sb.append(column.columnName).append(" ").append(column.columnType.toString());

				if (it1.hasNext()) {
					sb.append(", ");
				}
			}

			/*
			 * ݒ
			 */
			Iterator<Constraint> it2 = constraintList.iterator();
			Constraint constraint;
			while (it2.hasNext()) {
				constraint = it2.next();
				sb.append(constraint.columnName).append(" ").append(constraint.constraintType.toString());

				if (it2.hasNext()) {
					sb.append(", ");
				}
			}

			sb.append("); ");

			return sb.toString();
		}
	}

	/**
	 * Contextݒ肷
	 * @param context
	 */
	public void setContext(Context context) {
		this.context = context;
	}

	/**
	 * J̒lێNX
	 * @author Atsushi Nakamoto
	 *
	 */
	public class Column {
		/** J */
		public String columnName;
		/** J^Cv */
		public ColumnType columnType;
	}

	/**
	 * ̒lێNX
	 * @author ATLabo
	 *
	 */
	public class Constraint {
		/** J */
		public String columnName;
		/** ^Cv */
		public ConstraintType constraintType;
	}
}
