package net.atlabo.money.db.table;

import java.util.ArrayList;
import java.util.List;

/**
 * HISTORYe[u
 * DBo[W7ȍ~Ɏ
 * uev̓͗ێ
 * EREGIST_DATE	o^ݒ肷	INTEGER PRIMARY
 * ECATEGORY_ID	JeSݒ肷		TEXT
 * EWORD			e					TEXT
 * @author ATLabo
 *
 */
public class HistoryTable extends AbstractTable {
	public static final String COLUMN_REGIST_DATE = "REGIST_DATE";
	public static final String COLUMN_CATEGORY_ID = "CATEGORY_ID";
	public static final String COLUMN_WORD = "WORD";

	@Override
	public String getStatementOnCreate() {
		return new SQLCreator().setTableName("HISTORY")
				.addColumn(COLUMN_REGIST_DATE, ColumnType.INTEGER)
				.addColumn(COLUMN_CATEGORY_ID, ColumnType.TEXT)
				.addColumn(COLUMN_WORD, ColumnType.TEXT)
				.createSQL();
	}

	@Override
	public String[] getStatementOnUpdate(int oldVersion, int newVersion) {
		if (oldVersion == newVersion) {
			return null;
		}
		
		if (oldVersion >= 11) {
			// version11ȏ̏ꍇ̓Abvf[gȂ
			return null;
		}

		List<String> list = new ArrayList<String>();

		String sql = new SQLCreator().setTableName("HISTORY")
				.addColumn(COLUMN_REGIST_DATE, ColumnType.INTEGER)
				.addColumn(COLUMN_CATEGORY_ID, ColumnType.TEXT)
				.addColumn(COLUMN_WORD, ColumnType.TEXT)
				.createSQL();

		list.add(sql);

		return (String[]) list.toArray(new String[list.size()]);
	}

}
