package net.atlabo.money.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.params.ClientPNames;
import org.apache.http.client.params.CookiePolicy;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.util.Log;

public class HttpConnection {
	private SchemeRegistry registry;
	// ڎgpȂI
	private HttpResponse response;

	private String encode;

	private String content;



	public enum HttpMethod {
		POST, GET
	}

	public HttpConnection() {
		this.encode = "UTF-8";
		registry = new SchemeRegistry();
	}

	public HttpConnection(String encode) {
		this();
		this.encode = encode;
	}

	private HttpResponse getResponse() {
		if (response == null) {
			throw new RuntimeException("NGXg𔭍sĂ܂B");
		}
		return response;
	}

	public void execute(URL url, HttpMethod method, List<NameValuePair> list, Header... headers) {
    	try {
    		String protocol = url.getProtocol();
    		Log.v("banking", "protocol : " + protocol);
        	registry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));

        	if ("https".equals(protocol)) {
        		// HTTPS̏ꍇ
	        	SSLSocketFactory socketFactory = SSLSocketFactory.getSocketFactory();
	        	registry.register(new Scheme("https", socketFactory, 443));
        	}

			HttpParams params = new BasicHttpParams();
			HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_0);
			HttpProtocolParams.setContentCharset(params, encode);

			HttpClient client = new DefaultHttpClient(
					new ThreadSafeClientConnManager(params, registry), params);
			client.getParams().setParameter(ClientPNames.COOKIE_POLICY, CookiePolicy.BROWSER_COMPATIBILITY);

			HttpRequestBase requestBase = null;

			if (method.equals(HttpMethod.POST)) {
				requestBase = new HttpPost(url.toURI());

				if (list != null) {
					((HttpPost)requestBase).setEntity(new UrlEncodedFormEntity(list, encode));
				}
			} else if (method.equals(HttpMethod.GET)) {
				requestBase = new HttpGet(url.toURI());
			}

			response = client.execute(requestBase);

		} catch (URISyntaxException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		} catch (ClientProtocolException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
	}

	public String getContent() {
		if (content != null) {
			return content;
		}
		HttpResponse response = getResponse();
		BufferedInputStream bis = null;
		try {
			InputStream is = response.getEntity().getContent();
			BufferedReader br = new BufferedReader(new InputStreamReader(is, encode));
			String str = null;
			StringBuffer sb = new StringBuffer();
			while ((str = br.readLine()) != null) {
				sb.append(str).append("\n");
			}

			content = sb.toString();
			return content;
		} catch (IllegalStateException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
			throw new RuntimeException();
		} catch (IOException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
			throw new RuntimeException();
		} finally {
			if (bis != null) {
				try {
					bis.close();
				} catch (IOException e) {
				}
			}
		}
	}

	public Header[] getResponseHeader() {
		HttpResponse response = getResponse();
		return response.getAllHeaders();
	}

	public int getStatus() {
		return response.getStatusLine().getStatusCode();
	}

}
