package net.atlabo.money.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

public class Preference {

	public static final String PREFERENCE_NAME = "mywallet";

	public static final String KEY_PERIOD_DATE = "PERIOD_DATE";

	// twitter
	public static final String KEY_ACCESS_TOKEN = "ACCESS_TOKEN";
	public static final String KEY_ACCESS_TOKEN_SECRET = "ACCESS_TOKEN_SECRET";

	// facebook
	public static final String KEY_FB_ACCESS_TOKEN = "FB_ACCESS_TOKEN";
	
	// NWbg^C~O
	public static final String KEY_CREDIT_PAY_TIMING = "CREDIT_PAY_TIMING";
	/** w */
	public static final String CREDIT_BUY = "0";
	/**  */
	public static final String CREDIT_PAY = "1";


	private SharedPreferences pref;
	private Editor editor;
	private boolean isCommit;

	public Preference(Context context) {
		pref = context.getSharedPreferences(PREFERENCE_NAME,
				Context.MODE_WORLD_READABLE | Context.MODE_WORLD_WRITEABLE);
	}

	/**
	 * ߓ擾
	 * @return
	 */
	public int getPeriodDate() {
		return pref.getInt(KEY_PERIOD_DATE, 31);
	}

	public void setPeriodDate(int periodDate) {
		Editor e = createEditor();
		e.putInt(KEY_PERIOD_DATE, periodDate);
	}

	public String getAccessToken() {
		return pref.getString(KEY_ACCESS_TOKEN, null);
	}

	public void setAccessToken(String accessToken) {
		Editor e = createEditor();
		e.putString(KEY_ACCESS_TOKEN, accessToken);
	}

	public String getFBAccessToken() {
		return pref.getString(KEY_FB_ACCESS_TOKEN, null);
	}

	public void setFBAccessToken(String token) {
		Editor e = createEditor();
		e.putString(KEY_FB_ACCESS_TOKEN, token);
	}

	public String getAccessTokenSecret() {
		return pref.getString(KEY_ACCESS_TOKEN_SECRET, null);
	}

	public void setAccessTokenSecret(String tokenSecret) {
		Editor e = createEditor();
		e.putString(KEY_ACCESS_TOKEN_SECRET, tokenSecret);
	}
	
	public String getCreditPayTiming() {
		return pref.getString(KEY_CREDIT_PAY_TIMING, CREDIT_BUY);
	}
	
	public void setCreditPayTiming(String str) {
		Editor e = createEditor();
		e.putString(KEY_CREDIT_PAY_TIMING, str);
	}

	/**
	 * Editor𐶐
	 * @return
	 */
	private Editor createEditor() {
		if (editor == null) {
			editor = pref.edit();
		}

		return editor;
	}

	/**
	 * EditorR~bg
	 */
	public void commit() {
		if (editor == null) {
			return;
		}

		if (isCommit) {
			return;
		}

		editor.commit();
	}

	/**
	 * R~bgYh~
	 */
	public void finalize() {
		commit();
	}
}
