package net.atlabo.money.activity;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.adapter.MonthlyCategoryListAdapter;
import net.atlabo.money.dao.BudgetDao;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.dao.PlanMonthDao;
import net.atlabo.money.listener.OnFlickListener;
import net.atlabo.money.util.Preference;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;
import android.widget.TextView;

/**
 * JeSʂ̌f[^\
 * @author Atsushi Nakamoto
 *
 */
public class MonthlyCategoryActivity extends ExtendedActivity {
	private SimpleDateFormat df = new SimpleDateFormat("MMMMM, yyyy", Locale.US);
	private SimpleDateFormat df2 = new SimpleDateFormat("yyyyMM");
	private DecimalFormat decimalF = new DecimalFormat("###,###,###~");

	private OnFlickListener onFlickListener;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}

	@Override
	public void onResume() {
		super.onResume();
		setContentView(R.layout.monthly_category);
		
		// NWbg^C~O擾
		Preference pref = new Preference(this);
		String timing = pref.getCreditPayTiming();

		// 擾
		TextView tvDate = (TextView) findViewById(R.id.date);
		tvDate.setText(df.format(date));

		// ̍v擾
		ConnectionManager manager = ConnectionManager.getInstance(this);
		manager.setReadableDatabase();
		BudgetDao budgetDao = new BudgetDao(manager);
		int totalAmount = budgetDao.selectMonthlyTotal(df2.format(date));
		
		if (Preference.CREDIT_BUY.equals(timing)) {
			// x
			totalAmount = budgetDao.selectMonthlyTotal(df2.format(date));
		} else {
			// 
			totalAmount = budgetDao.selectMonthlyTotalAfterPay(df2.format(date));
		}
		
		String strTotalAmount = decimalF.format(totalAmount);
		TextView tvTotalAmount = (TextView) findViewById(R.id.totalAmount);
		tvTotalAmount.setText(strTotalAmount);

		// ̖ڕW擾
		PlanMonthDao planDao = new PlanMonthDao(manager);
		Integer totalPlanAmount = planDao.selectPlan(df2.format(date));
		String strTotalPlanAmount = null;
		if (totalPlanAmount == null) {
			strTotalPlanAmount = "----";
		} else {
			strTotalPlanAmount = decimalF.format(totalPlanAmount);
		}
		TextView tvPlanAmount = (TextView) findViewById(R.id.planAmount);
		tvPlanAmount.setText(strTotalPlanAmount);

		// JeSʂ擾
		List<Map<String, Object>> list = null;
		if (Preference.CREDIT_BUY.equals(timing)) {
			// x
			list = budgetDao.selectMonthlyByCategory(df2.format(date));
		} else {
			list = budgetDao.selectMonthlyByCategoryAfterPay(df2.format(date));
		}
		ListView listView = (ListView) findViewById(R.id.listview);
		MonthlyCategoryListAdapter adapter = new MonthlyCategoryListAdapter(this, list);
		listView.setAdapter(adapter);

		// tbNXi
		onFlickListener = new OnFlickListener(new Handler() {
			public void handleMessage(Message msg) {
				if (msg.what == OnFlickListener.FLICK_LEFT) {
					// tbN
					Calendar cal = Calendar.getInstance();
					cal.setTime(date);
					cal.add(Calendar.MONTH, 1);
					callThisActivityWithAnim(cal, R.anim.fadein_right, R.anim.fadeout_left);
					finish();
				} else if (msg.what == OnFlickListener.FLICK_RIGHT) {
					// EtbN
					Calendar cal = Calendar.getInstance();
					cal.setTime(date);
					cal.add(Calendar.MONTH, -1);
					callThisActivityWithAnim(cal, R.anim.fadein_left, R.anim.fadeout_right);
					finish();
				}
			}
		});

		manager.close();
	}

	/**
	 * 挎{^̏
	 * @param view
	 */
	public void onLastMonthClick(View view) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.MONTH, -1);
		callThisActivity(cal);
		finish();
	}

	/**
	 * {^̏
	 * @param view
	 */
	public void onNextMonthClick(View view) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.MONTH, 1);
		callThisActivity(cal);
		finish();
	}

	/**
	 * ActivityēxĂяo
	 * @param cal
	 */
	private void callThisActivity(Calendar cal) {
		date = cal.getTime();
		moveActivity(MonthlyCategoryActivity.class);
	}

	/**
	 * Ԃꍇ
	 * @param view
	 */
	public void onMonthlyClick(View view) {
		moveActivity(DailySummaryActivity.class);
	}

	public void onChartClick(View view) {
		moveActivity(MonthlyCategoryChartActivity.class);
	}

	@Override
	public boolean dispatchTouchEvent(MotionEvent ev) {
		onFlickListener.onTouch(null, ev);
		return super.dispatchTouchEvent(ev);
	}

	/**
	 * ActivityēxĂяo
	 * Aj[Vt
	 * @param cal
	 */
	private void callThisActivityWithAnim(Calendar cal, int from, int to) {
		date = cal.getTime();
		moveActivityWithAnimation(MonthlyCategoryActivity.class, from, to);
	}
}
