package net.atlabo.money.adapter;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import net.atlabo.money.R;
import net.atlabo.money.db.table.BudgetTable;
import net.atlabo.money.db.table.PlanMonthTable;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class DailySummaryListAdapter extends ArrayAdapter<Map<String, Object>> {
	private LayoutInflater inflater;
	private DecimalFormat decimalFormat = new DecimalFormat("###,###,###~");

	private SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
	private SimpleDateFormat df2 = new SimpleDateFormat("d(E)", Locale.JAPAN);

	private String yyyyMM;

	public DailySummaryListAdapter(Context context, List<Map<String, Object>> objects, String yyyyMM) {
		super(context, 0, objects);
		this.yyyyMM = yyyyMM;
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	public View getView(final int position, View convertView, ViewGroup parent) {
		if (convertView == null) {
			convertView = inflater.inflate(R.layout.daily_summary_item, null);
		}
		Map<String, Object> item = getItem(position);

		// t
		TextView tvDate = (TextView) convertView.findViewById(R.id.date);
		String strDate = yyyyMM + (String) item.get(BudgetTable.COLUMN_TX_DATE);
		try {
			// strDateDate^ɕϊă^Oɐݒ
			convertView.setTag(R.string.resource_date, df.parse(strDate));
		} catch (ParseException e) {
		}
		tvDate.setText(transferDate(strDate));
		Integer color = getColorByDay(strDate);
		tvDate.setTextColor(color);
		// z
		TextView tvAmount = (TextView) convertView.findViewById(R.id.amount);
		tvAmount.setText(decimalFormat.format(item.get(BudgetTable.COLUMN_AMOUNT)));
		// ڕW
		TextView tvPlan = (TextView) convertView.findViewById(R.id.plan);
		tvPlan.setText(decimalFormat.format(item.get(PlanMonthTable.COLUMN_PLAN_AMOUNT)));

		return convertView;
	}

	/**
	 * yyyyMMddtH[}bg̓td(E)ɕϊ
	 * @param date
	 * @return
	 */
	private String transferDate(String date) {
		try {
			return df2.format(df.parse(date));
		} catch (ParseException e) {
			return null;
		}
	}

	/**
	 * jƂ̐FԋpB
	 * yj͐
	 * j͐ԂԋpA
	 * ȊO͔ԋp
	 * @return
	 */
	private Integer getColorByDay(String strDate) {
		try {
			Date date = df.parse(strDate);
			int day = date.getDay();
			if (day == 0) {
				// j͐
				return Color.RED;
			} else if (day == 6) {
				// yj͐
				return Color.BLUE;
			} else {
				// ȊO͔
				return Color.WHITE;
			}
		} catch (ParseException e) {
			return Color.WHITE;
		}
	}

}
