package net.atlabo.money.logic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

import net.atlabo.money.exception.SystemException;
import android.content.Context;
import android.os.Environment;
import android.util.Log;

public class ExportToSD {
	/**
	 * DBt@CSDJ[hɃRs[
	 * AndroidManifest.xmlWRITE_EXTERNAL_STORAGEݒ肷邱
	 *
	 * @param Context context \bhĂяo(Activity)Context
	 * @param String dbName Rs[ƂȂf[^x[Xt@C
	 * @return Rs[ɐꍇtrue
	 * @throws IOException Ȃ񂩃G[Nꍇthrow
	 */
	public static boolean copyDb2Sd(Context context, String dbName) {

	    //ۑ(SDJ[h)̃fBNgm
	    String pathSd = new StringBuilder()
	                        .append(Environment.getExternalStorageDirectory().getPath())
	                        .append("/")
	                        .append(context.getPackageName())
	                        .toString();
	    File filePathToSaved = new File(pathSd);
	    if (!filePathToSaved.exists() && !filePathToSaved.mkdirs()) {
	    	Log.e("money", "SDJ[h̃ANZXɎs܂B");
	        throw new SystemException("SDJ[h̃ANZXɎs܂B");
	    }

	    final String fileDb = context.getDatabasePath(dbName).getPath();
	    final String fileSd = new StringBuilder()
	                            .append(pathSd)
	                            .append("/")
	                            .append(dbName)
	                            .toString();

	    Log.v("money", "copy from(DB): "+fileDb);
	    Log.v("money", "copy to(SD)  : "+fileSd);

	    try {
	    	File fileTarget = new File(fileSd);
	    	if (fileTarget != null && fileTarget.exists()) {
	    		// U폜
	    		Log.v("money", "t@C݂܂BU폜܂B");
	    		fileTarget.delete();
	    	}

			FileChannel channelSource = new FileInputStream(fileDb).getChannel();
			FileChannel channelTarget = new FileOutputStream(fileSd).getChannel();

			channelSource.transferTo(0, channelSource.size(), channelTarget);

			channelSource.close();
			channelTarget.close();
		} catch (IOException e) {
			Log.e("money", "SDJ[hւ̃Rs[Ɏs܂B", e);
			throw new SystemException("SDJ[hւ̃Rs[Ɏs܂B");
		}

	    return true;
	}
}
