package net.atlabo.money.webapi.iteminfo;

import java.net.URL;
import java.util.List;
import java.util.Map;

import net.arnx.jsonic.JSON;
import net.atlabo.money.exception.SystemException;
import net.atlabo.money.util.HttpConnection;
import net.atlabo.money.util.HttpConnection.HttpMethod;

import org.apache.http.NameValuePair;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.os.AsyncTask;

/**
 * ItemInformation̒ʐM̋ʃNX
 * @author Atsushi Nakamoto
 *
 */
public class ConnectionCommon extends AsyncTask<String, Integer, Map<String, Object>> implements OnCancelListener {
	public static final String BASE_URL = "http://iteminformationstorage.appspot.com/api/item/";

	private Context context;
	private ProgressDialog progresDialog;

	private String function;
	List<NameValuePair> paramList;

	public ConnectionCommon(Context context, String function, List<NameValuePair> paramList) {
		this.context = context;
		this.function = function;
		this.paramList = paramList;
	}

	@Override
	protected Map<String, Object> doInBackground(String... params) {
		HttpConnection connection = new HttpConnection("UTF-8");
		try {
			// TODO
			connection.execute(new URL(BASE_URL + function),
					HttpMethod.POST, paramList);


			int status = connection.getStatus();
			if (status != 200) {
				// TODO Xe[^XR[h200ȊȌꍇG[
				throw new SystemException("HTTPX|XsłB[" + status + "]");
			}

			String contents = connection.getContent();

			return JSON.decode(contents);

		} catch (SystemException e) {
			throw e;
		} catch (Exception e) {
			throw new SystemException("G[܂B", e);
		}
	}

	public void onPreExecute() {
		progresDialog = new ProgressDialog(context);
		progresDialog.setMessage("ʐM...");
		progresDialog.setCancelable(true);
		progresDialog.setOnCancelListener(this);
		progresDialog.show();
	}

	public void onPostExecute(Map<String, Object> result) {
		progresDialog.dismiss();
	}

	public void onCancelled() {
		progresDialog.dismiss();
	}

	public void onCancel(DialogInterface dialog) {
		this.cancel(true);
	}
}
