package net.atlabo.money.webapi.iteminfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import net.atlabo.money.exception.SystemException;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

import android.content.Context;
import android.util.Log;

/**
 * iĎ擾
 * @author Atsushi Nakamoto
 *
 */
public class ItemApi {

	private Context context;

	public ItemApi(Context context) {
		this.context = context;
	}

	/**
	 * R[h菤iĎ擾
	 * 擾łȂꍇNULLԋp
	 * ȊÕG[ꍇExceptionX[
	 * @param code
	 * @return
	 * @throws ItemInformationException
	 */
	public Item selectItem(String code) throws ItemInformationException {
		List<NameValuePair> list = new ArrayList<NameValuePair>();
		NameValuePair nvp = new BasicNameValuePair("code", code);
		list.add(nvp);

		Item item;
		try {
			ConnectionCommon con = new ConnectionCommon(context, "select", list);
			Map<String, Object> map = con.execute().get();

			String resultCode = (String) map.get("resultCode");

			if ("0001".equals(resultCode)) {
				return null;
			}

			if ("1001".equals(resultCode)) {
				throw new ItemInformationException("R[h͂łB");
			}

			Map<String, Object> bodyMap = (Map<String, Object>) map.get("body");
			String itemName = (String) bodyMap.get("itemName");

			item = new Item();
			item.setCode(code);
			item.setItemName(itemName);
		} catch (ItemInformationException e) {
			throw e;
		} catch (Exception e) {
			Log.e("ItemInfo", "ʐMŃG[܂B", e);
			throw new SystemException("ʐMŃG[܂B", e);
		}

		return item;
	}

	/**
	 * io^
	 * @param item
	 * @throws ItemInformationException
	 */
	public void registItem(Item item) throws ItemInformationException {
		List<NameValuePair> list = new ArrayList<NameValuePair>();
		list.add(new BasicNameValuePair("code", item.getCode()));
		list.add(new BasicNameValuePair("itemName", item.getItemName()));

		try {
			ConnectionCommon con = new ConnectionCommon(context, "regist", list);
			Map<String, Object> map = con.execute().get();

			String resultCode = (String) map.get("resultCode");

			if ("1001".equals(resultCode)) {
				throw new ItemInformationException("R[h͂łB");
			}

			if ("1002".equals(resultCode)) {
				throw new ItemInformationException("̂͂łB");
			}


		} catch (ItemInformationException e) {
			throw e;
		} catch (Exception e) {
			Log.e("ItemInfo", "ʐMŃG[܂B", e);
			throw new SystemException("ʐMŃG[܂B", e);
		}

	}
}
