#ifndef _IHANDLERS_H
#define _IHANDLERS_H

#include <sys/types.h>

void asm_defaulthandler();
void asm_i00h();
void asm_i01h();
void asm_i02h();
void asm_i03h();
void asm_i04h();
void asm_i05h();
void asm_i06h();
void asm_i07h();
void asm_i08h();
void asm_i09h();
void asm_i0Ah();
void asm_i0Bh();
void asm_i0Ch();
void asm_i0Dh();
void asm_i0Eh();
void asm_i10h();
void asm_i11h();
void asm_i12h();
void asm_i13h();
void asm_process_switch(); // int 0x20
void asm_pictimer();  // int 0x20
void asm_i21h();
void asm_fdchandler(); // int 0x26
void asm_syscall(); // int 0x80

void defaulthandler();
void i00h();
void i01h();
void i02h();
void i03h();
void i04h();
void i05h();
void i06h();
void i07h();
void i08h();
void i09h();
void i00h();
void i0Ah();
void i0Bh();
void i0Ch();
void i0Eh();
void i10h();
void i11h();
void i12h();
void i13h();
void i20h_pictimer();
PUBLIC void i20h_process_switch(int is_usermode, u_int32_t iret1,
                                u_int32_t iret2, u_int32_t iret3,
                                u_int32_t iret4, u_int32_t iret5,
                                u_int32_t ebp);
void i21h_keyhandler();
void i26h_fdchandler();

void i0Dh_GPEfault(u_int16_t di, u_int16_t si, u_int16_t bp,
				   u_int32_t esp, u_int32_t ebx, u_int32_t edx,
				   u_int32_t ecx, u_int32_t eax, u_int16_t es,
				   u_int16_t ds, u_int32_t error, u_int32_t eip,
				   u_int16_t cs, u_int16_t dummy, u_int32_t eflags);

PUBLIC int i80h_syscall(u_int32_t p1, u_int32_t p2, u_int32_t p3,
                        u_int32_t p4, u_int32_t p5, u_int32_t p6,
                        u_int32_t nr_syscall);

#endif /* _IHANDLERS_H */
