#ifndef _STDLIB_H
#define _STDLIB_H

#include <types.h>
#include <ext3fs.h>

extern ssize_t write(int fd, const void *buf, size_t count);
extern int open(const char *pathname, int flags, mode_t mode);
extern ssize_t read(int fd, void *buf, size_t count);
extern int execve(const char *filename, char *const argv[],
                  char *const envp[]);
extern void exit(int status);
extern off_t lseek(int fildes, off_t offset, int whence);
extern int mkdir(const char *pathname, mode_t mode);
extern int creat(const char *pathname, mode_t mode);
extern ext3_dentry* getdentry();


#endif /* _STDLIB_H */
