﻿/**
 *@file api_live.h
 *
 *@English
 *@brief NicoLive API Wrapper Functions@n
 *@EndEnglish
 *
 *@Japanese
 *@brief ニコニコ生放送APIのラッパー関数群@n
 *@n
 *@n
 *<b>nlc_live系列エラー</b>@n
 *\arg \c NLCE_API_LIVE_NOT_FOUND - 番組が存在しない
 *\arg \c NLCE_API_LIVE_CLOSED - 番組が終了している
 *\arg \c NLCE_API_LIVE_FULL - 番組が満員
 *\arg \c NLCE_API_LIVE_REQUIRE_COMMUNITY_MEMBER - コミュニティーメンバー限定番組、コミュニティーに参加していない
 *\arg \c NLCE_API_LIVE_NOT_PERMITTED - APIを呼び出す有効時間を超過した
 *@n
 *これらのエラーは、\c NLCE_API_LIVE_FIRST から \c NLCE_API_LIVE_LAST までの数値で定義されている。@n
 *参考: #nlc_err_isliveerror() @n
 *@n
 *@sa "api.h" これらのエラーの他に、api.hで説明されている汎用エラーが返される場合がある。
 *@EndJapanese
 */
#ifndef _NLC_API_LIVE_H
#define _NLC_API_LIVE_H
#include <NicoLib/types.h>

#ifdef __cplusplus
extern "C" {
#endif


/** 
 *@English
 *@defgroup NicoLive
 *@EndEnglish
 *
 *@Japanese
 *@defgroup ニコニコ生放送
 *@EndJapanese
 *
 */
/*@{*/ /* vNicoLivev */


/** 
 *@English
 *@defgroup Authentication API
 *@EndEnglish
 *
 *@Japanese
 *@defgroup 認証API
 *@EndJapanese
 *
 */
/*@{*/ /* vAuthentication APIv */


NLCResult nlc_live_antenna(NLCAlertData *adata, const char *mail, const char *password, NLCResult *api_err);


/*@}*/ /* ^Authentication API^ */


/** 
 *@English
 *@defgroup Alert Server API
 *@EndEnglish
 *
 *@Japanese
 *@defgroup アラートサーバーAPI
 *@EndJapanese
 *
 */
/*@{*/ /* vAlert Server APIv */
 

/**
 *@English
 *@brief Get Alert Server's information
 *
 *No authentication required.
 *
 *@param adata Pointer to a structure to store Alert Server's information
 *@param api_err Pointer to a variable to store API error information
 *
 *@return nlc_live errors
 *@EndEnglish
 *
 *@Japanese
 *@brief アラートサーバーの情報を取得する
 *
 *認証情報は必要ない。
 *
 *@param adata 取得したデータを格納する構造体へのポインタ
 *@param api_err API周りのエラーが出た場合に詳細情報を格納する変数
 *
 *@return nlc_live系列エラー
 *@EndJapanese
 */
NLCResult nlc_live_getalertinfo(NLCAlertData *adata, NLCResult *api_err);

/**
 *@English
 *@brief Gets Alert Server's information and joined community/channel list
 *
 *#nlc_live_antenna must be called for param \c adata before this function is called.
 *
 *@param adata Pointer to a structure to store Alert Server's information
 *@param api_err Pointer to a variable to store API error information
 *
 *@return Error information
 *@retval NLCE_OK Success
 *@EndEnglish
 *
 *@Japanese
 *@brief アラートサーバーの情報、参加中のコミュニティー／チャンネルの一覧を取得する
 *
 *この関数を使う前に、\c adata に対して nlc_live_antenna が呼ばれている必要がある。
 *
 *@param adata 取得したデータを格納する構造体へのポインタ
 *@param api_err API周りのエラーが出た場合に詳細情報を格納する変数
 *
 *@return nlc_live系列エラー
 *@EndJapanese
 */
NLCResult nlc_live_getalertstatus(NLCAlertData *adata, NLCResult *api_err);


/*@}*/ /*^Alert Server API^*/



/** 
 *@English
 *@defgroup Stream Information API
 *@EndEnglish
 *
 *@Japanese
 *@defgroup 番組情報API
 *@EndJapanese
 *
 */
/*@{*/ /* vStream Information APIv */
/*@}*/ /* ^Stream Information API^ */

/*@}*/ /* ^NicoLive^ */



#ifdef __cplusplus
}
#endif
#endif
