﻿/**
 *@file types.h
 *
 *@English
 *Typedefs, structures and those stuffs
 *@EndEnglish
 *
 *@Japanese
 *ライブラリ全体で使われる構造体等の定義
 *@EndJapanese
 *
 *
 *
 *
 *
 */



#ifndef _NLC_TYPES_H
#define _NLC_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	/* General errors */
	/* all NLC functions may return these errors */
	NLCE_OK = 0,									/* Success */
	NLCE_API_ERR,									/* API errors */
	NLCE_UNK_ERR,									/* global unknownn error */
	NLCE_BAD_FUNCTION_ARGUMENT,						/* bad function argument */
	NLCE_NO_MEMORY,									/* no more memory to allocate */

	/* Library errors */
	NLCE_CURL_ERR,									/* libcurl errors */ 
	NLCE_LIBXML_ERR,								/* libxml errors */
	NLCE_XMLPARSER_ERR,								/* nlc_xmlparser errors */


	/* API errors */
	/* will be used when the func returns NLCE_API_ERR */
	NLCE_API_OK = 1000,								/* no API error */
	NLCE_API_UNK_ERR,								/* unknown API error */

	/* API errors - general */
		NLCE_API_GENERAL_FIRST = 1100,
		NLCE_API_MAINTENANCE,						/* maintenance mode */
		NLCE_API_ACCOUNT_DATA_INCORRECT,			/* mail/pass is wrong */
		NLCE_API_ACCOUNT_LOCKED,					/* account is locked */
		NLCE_API_GENERAL_LAST,

	/* API errors - video */
		NLCE_API_VIDEO_FIRST = 1200,
		NLCE_API_VIDEO_LAST,

	/* API errors - seiga */
		NLCE_API_SEIGA_FIRST = 1300,
		NLCE_API_SEIGA_LAST,

	/* API errors - live */
		NLCE_API_LIVE_FIRST = 1400,
		NLCE_API_LIVE_NOT_FOUND,					/* stream not found */
		NLCE_API_LIVE_CLOSED,						/* stream is closed */
		NLCE_API_LIVE_FULL,							/* stream is full (not even standing seat) */
		NLCE_API_LIVE_REQUIRE_COMMUNITY_MEMBER,		/* require community member */
		NLCE_API_LIVE_NOT_PERMITTED,				/* API request timeout */
		NLCE_API_LIVE_LAST,


	NLCE_API_LAST,


	NLCE_LAST										/* Never use */
}NLCResult;

typedef struct
{
	/* authentication */
	char *ticket;

	/* alert server */
	char *addr;
	unsigned int port;
	unsigned int thread;
}NLCAlertData;


#ifdef __cplusplus
}
#endif
#endif

