﻿#include <stdio.h>
#include <string.h>

#include <curl/curl.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>

#include <NicoLib/NicoLib.h>
#include <NicoLib/general.h>
#include <NicoLib/http.h>
#include <NicoLib/xmlparser.h>


int nlc_init(void)
{
	xmlInitParser();
	//LIBXML_TEST_VERSION
	return 0;
}

int nlc_cleanup(void)
{
	xmlCleanupParser();
	return 0;
}


NLCAlertData *nlc_new_alertdata(void)
{
	NLCAlertData *adata;

	adata = (NLCAlertData *)malloc(sizeof(NLCAlertData));
	
	adata->ticket = NULL;

	adata->addr = (char *)malloc(sizeof(char) * 128);
	adata->port = 0;
	adata->thread = 0;

	return adata;
}

void nlc_free_alertdata(NLCAlertData *adata)
{
	if(!adata)
	{
		return;
	}

	if(adata->ticket) free(adata->ticket);
	if(adata->addr) free(adata->addr);

	free(adata);
}

