﻿/**
 *@file error.h
 *
 *@English
 *@brief Error handling functions
 *@EndEnglish
 *
 *@Japanese
 *@brief エラー関係の関数
 *@EndJapanese
 *
 *
 *
 */
#ifndef _NLC_ERR_H
#define _NLC_ERR_H
#include <NicoLib/types.h>

#ifdef __cplusplus
extern "C" {
#endif

//=============================================
/** 
 *@English
 *@defgroup Error handling functions
 *@EndEnglish
 *
 *@Japanese
 *@defgroup エラー関係の関数
 *@EndJapanese
 *
 */
/*@{*/


/**
 *@English
 *@brief Get more information from enumerator #NLCResult
 *
 *@return Error information
 *@EndEnglish
 *
 *
 *@Japanese
 *@brief 列挙体#NLCResultから詳細情報を出力する
 *
 *@return エラーの詳細情報
 *@EndJapanese
 */
const char *nlc_err_tostr(NLCResult res);


/**
 *@English
 *@brief Check whether the error is nlc_video error
 *
 *@retval 0 FALSE
 *@retval 1 TRUE
 *@EndEnglish
 *
 *
 *@Japanese
 *@brief nlc_video系列のエラーなのか判定する
 *
 *@retval 0 FALSE
 *@retval 1 TRUE
 *@EndJapanese
 */
int nlc_err_isvideoerr(NLCResult res);


/**
 *@English
 *@brief Check whether the error is nlc_seiga error
 *
 *@retval 0 FALSE
 *@retval 1 TRUE
 *@EndEnglish
 *
 *
 *@Japanese
 *@brief nlc_seiga系列のエラーなのか判定する
 *
 *@retval 0 FALSE
 *@retval 1 TRUE
 *@EndJapanese
 */
int nlc_err_isseigaerr(NLCResult res);


/**
 *@English
 *@brief Check whether the error is nlc_live error
 *
 *@retval 0 FALSE
 *@retval 1 TRUE
 *@EndEnglish
 *
 *
 *@Japanese
 *@brief nlc_live系列のエラーなのか判定する
 *
 *@retval 0 FALSE
 *@retval 1 TRUE
 *@EndJapanese
 */
int nlc_err_isliveerr(NLCResult res);


/*@}*/ /*^Error handling functions^*/

#ifdef __cplusplus
}
#endif
#endif
