﻿#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <curl/curl.h>
#include <NicoLib/NicoLib.h>

int main(void)
{
	char *buf = NULL;
	char *ptr = NULL;
	char *mail = "unko_king@live.jp", *password = "unkoking";
	unsigned int i = 0;
	int count = 0;

	NLCResult res = NLCE_OK;
	NLCResult api_err = NLCE_API_OK;
	NLCAlertData *adata;

	nlc_init();
	adata = nlc_new_alertdata();


	res = nlc_live_getalertinfo(adata, &api_err);
	if(res != NLCE_OK)
	{
		printf("error: %s\n", nlc_err_tostr(res));

		if(res == NLCE_API_ERR)
		{
			printf("api error: %s\n", nlc_err_tostr(api_err));
		}
	}

	printf("adata->addr: [%s]\n", adata->addr);
	printf("adata->port: [%d]\n", adata->port);
	printf("adata->thread: [%d]\n", adata->thread);


	res = nlc_live_antenna(adata, mail, password, &api_err);
	if(res != NLCE_OK)
	{
		printf("error: %s\n", nlc_err_tostr(res));
		printf("api_err: %s\n", nlc_err_tostr(api_err));
	}


	res = nlc_live_getalertstatus(adata, &api_err);
	if(res != NLCE_OK)
	{
		printf("error: %s\n", nlc_err_tostr(res));

		if(res == NLCE_API_ERR)
		{
			printf("api error: %s\n", nlc_err_tostr(api_err));
		}
	}


	nlc_free_alertdata(adata);
	nlc_cleanup();
	return 0;
}