using System.Collections;

namespace Nicolib.Cookie.BrowserCookie {
	class classCookies {
		private classDomain domain_;
		internal classCookies() {
			domain_ = new classDomain();
		}
		internal string domain {
			get { return domain_.domain; }
			set { domain_.domain = value; }
		}
		internal string page {
			get { return domain_.page; }
			set { domain_.page = value; }
		}
		internal void addCookie(string key, string value) {
			domain_.addCookie(key, value);
		}
		internal Hashtable cookies {
			get { return domain_.cookies; }
			set { domain_.cookies = value; }
		}
		internal bool isExistCookieKey(string key) {
			return domain_.cookies.ContainsKey(key);
		}

		internal class classDomain {
			private string domain_;
			private classPage page_;

			public classDomain() {
				page_ = new classPage();
			}

			public string domain {
				get { return domain_; }
				set { domain_ = value; }
			}
			public string page {
				get { return page_.page; }
				set { page_.page = value; }
			}

			public void addCookie(string key, string value) {
				page_.addCookie(key, value);
			}
			public Hashtable cookies {
				get { return page_.cookies; }
				set { page_.cookies = value; }
			}

			public class classPage {
				private string page_;
				private Hashtable cookieList_;

				public classPage() {
					cookieList_ = new Hashtable();
				}

				public string page {
					get { return page_; }
					set { page_ = value; }
				}

				public void addCookie(string key, string value) {
					cookieList_.Add(key, new classCookie(key, value));
				}
				public void addCookie(classCookie cookie) {
					cookieList_.Add(cookie.key, cookie);
				}
				public Hashtable cookies {
					get { return cookieList_; }
					set { cookieList_ = value; }
				}

				public class classCookie {
					private string key_;
					private string value_;

					public classCookie(string key, string value) {
						key_ = key;
						value_ = value;
					}

					public string key {
						get { return key_; }
						set { key_ = value; }
					}
					public string value {
						get { return value_; }
						set { value_ = value; }
					}

				}

			}
		}
	}
}
