using System;
using System.Collections;
using System.IO;
using System.Text;

namespace Nicolib.Cookie.BrowserCookie {
	class OperaCookieGet : CookieBase {

		string host = "nicovideo";
		string key  = "user_session";

		public OperaCookieGet(){
			ProcessList.Add( new ProcessInfo( "opera"    , true , Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData),"Opera\\Opera\\profile\\cookies4.dat") ));
			ProcessList.Add( new ProcessInfo( "opera"    , true , "profile\\cookies4.dat" ) );
			ProcessList.Add( new ProcessInfo( "op"       , true , "profile\\cookies4.dat" ) );
			ProcessList.Add( new ProcessInfo( "op.com"   , true , "profile\\cookies4.dat" ) );
			ProcessList.Add( new ProcessInfo( "operausb" , true , "profile\\cookies4.dat" ) );
		}
		byte[] data_;
		private struct header {
			public int file_version_number;
			public int app_version_number;
			public int idtag_length;
			public int length_length;
		}
		private struct record {
			// application specific tag to identify content type
			public int tag_id;
			// Length of payload
			public int length;
			// Payload/content of the record
			public byte[] bytepayload;
		};
		private ArrayList getCookieData(string filename , string url , string key) {
			int index = 0;
			ArrayList result = null;
			record recordData;
			classCookies cookies = null;

			if(!File.Exists( filename ))
				return null;  // t@C̗L`FbN

			if(filename != string.Empty) {
				data_ = null;
				using(FileStream reader = new FileStream( filename , FileMode.Open , FileAccess.Read )) {
					// oCiǂݍ
					BinaryReader binReader = new BinaryReader( reader );
					// w肵AhXɓǂݍ݈ʒuړ
					reader.Seek( 0 , SeekOrigin.Begin );
					// ǂݍ
					data_ = binReader.ReadBytes( (int)reader.Length );

					binReader.Close();
					reader.Close();
				}
			}

			header headerData = getHeader( data_ , ref index );

			//version check
			if(( headerData.file_version_number & 0xfffff000 ) == 0x00001000) {
				result = new ArrayList();
				for( ; data_.Length > index ; ) {
					recordData = getRecord( data_ , headerData , ref index );
					// ItO͖ʓ|Ȃ̂ŌȂB
					// Y^OIDoϐɒlB
					switch(recordData.tag_id) {
						case 0x01:  // Domain Record Start
							if(cookies != null && url == cookies.domain) {
								if(key == string.Empty || cookies.isExistCookieKey( key )) {
									result.Add( cookies );
									cookies = null;
								}
							}
							cookies = new classCookies();
							getDomainRecode( recordData.bytepayload , headerData , ref cookies );
							break;
						case 0x02:  // Path Record Start
							if(cookies != null && url == cookies.domain) {
								getPageRecode( recordData.bytepayload , headerData , ref cookies );
							}
							break;
						case 0x03:  // Cookie Record Start
							if(cookies != null && url == cookies.domain) {
								getCookieRecode( recordData.bytepayload , headerData , key , ref cookies );
							}
							break;
					}
				}
				if(cookies != null && url == cookies.domain) {
					if(key == "" || cookies.isExistCookieKey( key )) {
						result.Add( cookies );
						cookies = null;
					}
				}
			}

			return result;
		}
		private void getDomainRecode(byte[] data , header headerData , ref classCookies cookies) {
			int index = 0;
			record recordData;

			for( ; data.Length > index ; ) {
				recordData = getRecord( data , headerData , ref index );

				switch(recordData.tag_id) {
					case 0x1e:  // Domain Name
						cookies.domain = Encoding.ASCII.GetString( recordData.bytepayload );
						break;
				}
			}
		}
		private void getPageRecode(byte[] data , header headerData , ref classCookies cookies) {
			int index = 0;
			record recordData;

			for( ; data.Length > index ; ) {
				recordData = getRecord( data , headerData , ref index );

				switch(recordData.tag_id) {
					case 0x1d:  // Page Name
						cookies.page = Encoding.ASCII.GetString( recordData.bytepayload );
						break;
				}
			}
		}
		private void getCookieRecode(byte[] data , header headerData , string key , ref classCookies cookies) {
			int index = 0;
			record recordData;
			string cookieKey   = string.Empty;
			string cookieValue = string.Empty;

			for( ; data.Length > index ; ) {

				recordData = getRecord( data , headerData , ref index );

				switch(recordData.tag_id) {
					case 0x10:  // Cookie Name
						cookieKey = Encoding.ASCII.GetString( recordData.bytepayload );
						break;
					case 0x11:  // Cookie Value
						if(key == string.Empty || key == cookieKey) {
							cookieValue = Encoding.ASCII.GetString( recordData.bytepayload );
						}
						break;
				}
			}
			if(key == string.Empty || key == cookieKey) {
				cookies.addCookie( cookieKey , cookieValue );
			}
		}
		private header getHeader(byte[] data , ref int index) {
			header headerData = new header();

			headerData.file_version_number = data[0] * 0x1000000 + data[1] * 0x10000 + data[2] * 0x100 + data[3];
			headerData.app_version_number = data[4] * 0x1000000 + data[5] * 0x10000 + data[6] * 0x100 + data[7];
			headerData.idtag_length = data[8] * 0x100 + data[9];
			headerData.length_length = data[10] * 0x100 + data[11];

			index += 12;

			return headerData;
		}
		private record getRecord(byte[] data , header headerData , ref int index) {
			record recordData = new record();
			int i = 0;
			byte topData = data[index];
			int MSB = 0x80;

			for(i = 0 ; ( headerData.idtag_length > i ) && ( data.Length > index ) ; i++ , index++) {
				recordData.tag_id += (int)Math.Pow( (double)0x100 , (double)( headerData.idtag_length - i - 1 ) ) * (int)data[index];
			}
			MSB *= (int)Math.Pow( (double)0x100 , (double)i - 1 );

			// MSBON̂ƂATag ID݂̂ɂȂBiȍ~DataLength,Data͂Ȃj
			if(( topData & MSB ) == 0) {

				for(i = 0 ; ( headerData.length_length > i ) && ( data.Length > index ) ; i++ , index++) {
					recordData.length += (int)Math.Pow( (double)0x100 , (double)( headerData.length_length - i - 1 ) ) * (int)data[index];
				}

				recordData.bytepayload = new byte[recordData.length];

				int copyLength = recordData.length > data.Length ? data.Length : recordData.length;
				Array.Copy( data , index , recordData.bytepayload , 0 , copyLength );

				index += copyLength;
			}

			return recordData;
		}

		protected override string CookieGet(string path) {
			string Data = null;
			ArrayList result = getCookieData( path , host , key );
			if(result.Count > 0) {
				classCookies cookies = (classCookies)result[0];
				Data = ( (classCookies.classDomain.classPage.classCookie)( cookies.cookies[key] ) ).value;
			}
			return ( Data );
		}
	}
}
