﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.Web;
using System.IO;

namespace NicoLib {
	public class Alert:Nico{
		#region public
		public bool status { get; private set; }
		#endregion

		#region private
		private Thread alertThread;

		private string addr;
		private string port;
		private string thread;
		#endregion

		/// <summary>
		/// アラートが飛んできた時のイベント
		/// </summary>
		/// <param name="info"></param>
		public delegate void AlertHandler(AlertInfo info);
		public event AlertHandler getAlertEvent;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		public Alert() : base() {
			initialization();
		}

		/// <summary>
		/// コンストラクタ - ログイン
		/// </summary>
		public Alert(string mail,string password) : base(mail,password) {
			initialization();
		}

		private void initialization() {
			this.status = false;
		}

		/// <summary>
		/// 取得開始
		/// </summary>
		/// <returns>正常に開始したか</returns>
		public bool Start() {
			if ( status == true ) return false;

			//初期化
			#region memo
			/* もしかしてログイン済み処理いらない子？
			if ( isLogin ) {
				//ログイン済み処理
				string res1_s = HttpPost("https://secure.nicovideo.jp/secure/login?site=nicolive_antenna" ,
						"mail={0}&password={1}" ,
						"kyubuns_jp@yahoo.co.jp" , "admjgptw"
						);
				XmlDocument res1 = new XmlDocument();
				res1.LoadXml(res1_s);
				ticket = res1.SelectSingleNode("nicovideo_user_response/ticket").InnerText;
				Console.WriteLine("->ticket : " + ticket);
				string res2_s = HttpPost("http://live.nicovideo.jp/api/getalertstatus" ,
						"ticket={0}" ,
						ticket
						);
				XmlDocument res2 = new XmlDocument();
				res2.LoadXml(res2_s);
				addr = res2.SelectSingleNode("getalertstatus/ms/addr").InnerText;
				port = res2.SelectSingleNode("getalertstatus/ms/port").InnerText;
				thread = res2.SelectSingleNode("getalertstatus/ms/thread").InnerText;
				Console.WriteLine("->addr : " + addr);
				Console.WriteLine("->port : " + port);
				Console.WriteLine("->thread : " + thread);
			}
			 */
			#endregion

			string res = HttpPost("http://live.nicovideo.jp/api/getalertinfo");
			XmlDocument xml = new XmlDocument();
			xml.LoadXml(res);
			addr = xml.SelectSingleNode("getalertstatus/ms/addr").InnerText;
			port = xml.SelectSingleNode("getalertstatus/ms/port").InnerText;
			thread = xml.SelectSingleNode("getalertstatus/ms/thread").InnerText;
			
			//スレ建て
			this.status = true;
			this.alertThread = new Thread(new ThreadStart(this.AlertMain));
			this.alertThread.IsBackground = true;
			this.alertThread.Start();

			return true;
		}

		private void AlertMain() {
			using ( TcpClient tc = new TcpClient(addr , int.Parse(port)) )
			using ( NetworkStream ns = tc.GetStream() ) {
				string req = string.Format("<thread thread=\"{0}\" version=\"20061206\" res_from=\"-1\" /> " , thread);

				byte[] sendBytes = Encoding.UTF8.GetBytes(req);
				sendBytes[sendBytes.Length - 1] = 0;
				ns.Write(sendBytes , 0 , sendBytes.Length);

				bool flag = true;
				while ( ns.CanRead && flag ) {
					byte[] resBytes = new byte[500];
					int resSize = ns.Read(resBytes , 0 , resBytes.Length);
					if ( resSize == 0 ) break;
					string message = Encoding.UTF8.GetString(resBytes);
					string[] elements = message.Split(new string[] { "\0" } , StringSplitOptions.RemoveEmptyEntries);

					foreach ( string receiveData in elements ) {
						if ( !receiveData.Contains("chat") ) continue;

						string[] parts = Convenience.RemoveTag(receiveData).Split(',');
						AlertInfo info = new AlertInfo(parts[0] , parts[1] , parts[2]);
						this.getAlertEvent(info);
					}
				}
			}
		}

		/// <summary>
		/// 接続を切断する
		/// </summary>
		/// <returns></returns>
		public bool DisConnect() {
			try {
				alertThread.Abort();
				status = false;
				return true;
			}
			catch {
				return false;
			}
		}
	}
}