<?php
/**
 * NicoAPI.class.php
 * 
 * @author poochin
 * @package nicolib
 * @version $Id:$
 * @copyright Copyright (c) 2009-2010 poochin.
 */

abstract class NicoAPI
{
    /* public variables */
    // none.
    
    /* private variables */
    private $_api_getstatusplayer = "http://watch.live.nicovideo.jp/api/getplayerstatus";
    private $_api_getpostkey = "http://live.nicovideo.jp/api/getpostkey";
    private $_api_getalertstatus = 'http://live.nicovideo.jp/api/getalertstatus';
    
    /* protected variables */
    protected $_curl_handle;
    protected $_login_urls = array();
    
    protected $_login_xml_raw;  // result of login xml as string
    protected $_login_xml;      // result of login xml as simple_xml

    /* abstract public functions */
    abstract public function login($mail, $password);
    
    /* abstract private functions */
    // yet none.
    
    /* abstract protected functions */
    // none.
    
    /* public functions */
    public function __construct()
    {
        self::setAPIURL();
        self::initCurlHandle();
    }
    
    public function __destruct()
    { }
    
    public function getpostkey()
    {
        // $this->_api_getpostkey;
        // ?block_no={$this->liveinfo['block_no']}&thread={$this->liveinfo['thread']}
    }
    
    /* private functions */
    private function setAPIURL ()
    {
        $this->_login_urls[ID_NICO_VIDEO] = "";
        $this->_login_urls[ID_NICO_LIVE] = "https://secure.nicovideo.jp/secure/login?site=nicolive";
        $this->_login_urls[ID_NICO_ALERT] = "https://secure.nicovideo.jp/secure/login?site=nicolive_antenna";
    }
    
    private function initCurlHandle()
    {
        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie.txt');
        curl_setopt($ch, CURLOPT_SSLVERSION, 3);
        
        $this->_curl_handle = $ch;
    }
    
    public function close()
    {
        fclose($this->_fp);
        $this->_fp = null;
    }
    
    /* protected functions */
    protected function api_getplayerstatus($lv_id)
    {
        curl_setopt($this->_curl_handle, CURLOPT_URL, $this->_api_getstatusplayer);
        curl_setopt($this->_curl_handle, CURLOPT_POSTFIELDS, array('v' => $lv_id));
        
        return curl_exec($this->_curl_handle);
    }
    
    protected function api_getalertstatus($ticket)
    {
        curl_setopt($this->_curl_handle, CURLOPT_URL, $this->_api_getalertstatus);
        curl_setopt($this->_curl_handle, CURLOPT_POSTFIELDS, array('ticket'=>$ticket));
        
        return curl_exec($this->_curl_handle);
    }
}
