<?php
require_once 'conf.php';

header('Content-Type: text/javascript');

$t = time();	// for LOG_FILE delete check
if (file_exists(LOG_FILE)) {
	if (filemtime(LOG_FILE) + 10 * 60 < $t) {
		unlink(LOG_FILE);
	}
}
$c2db = new C2DB;

/**
 * New message was posted
 */
if (!empty($_POST['message']) && strlen($_POST['message']) < 140) {
	$uhash = hash("crc32", $_SERVER['REMOTE_ADDR']);
	$message = $_POST['message'];htmlentities($_POST['message'], ENT_NOQUOTES, 'UTF-8');
	$message = preg_replace("/\r?\n/", "<br/>", $message);
	$addtime = time();
	
	$c2db->postMessage($uhash, $message, $addtime);
	exit;
}

/* if timestamp or rowid is none, quit program */
if (is_null($_GET['timestamp']) || is_null($_GET['rowid'])) {
	exit;
}

$rowid = (int)$_GET['rowid'];			// messages's rowid in database
$timestamp = (int)$_GET['timestamp'];	// this unixtime, user still getted

if ($timestamp == 0) {
	$messages = $c2db->getAllMessages();
	$output = NULL;
	foreach ($messages as $message) {
		$output .= implode("<>",$message)."\n";
	}
	echo trim($output);
	exit;
}

/**
 * and compare timestamp
 * if database updated, it break loop
 */
$s = time();
while (filemtime(LOG_FILE) <= $timestamp) {
	// wait 0.5sec
	usleep(500000);
	clearstatcache();
	if (time() - $s > 10) {
		return;
	}
}

$messages = $c2db->getNewerMessages($rowid);
$output = NULL;
foreach ($messages as $message) {
	$output .= implode("<>",$message)."\n";
}
echo trim($output);
