﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Collections;

namespace NicoLib {
	public class AlertInfo : Basic {
		public int flag { get; private set; }
										//0 - 情報無し
										//1 - アラート情報のみ
										//2 - Info情報まであり

		public string broadcastID { get; private set; }
		public string communityID { get; private set; }
		public string userID { get; private set; }

		private string _title;
		public string title {
			get {
				if ( _title == null ) {
					this.GetMore();
				}
				return _title;
			}
			private set {
				this._title = value;
			}
		}
		private string _description;
		public string description {
			get {
				if ( _description == null ) {
					this.GetMore();
				}
				return _description;
			}
			private set {
				this._description = value;
			}
		}
		private string _requestID;
		public string requestID {
			get {
				if ( _requestID == null ) {
					this.GetMore();
				}
				return _requestID;
			}
			private set {
				this._requestID = value;
			}
		}
		private string _thumbnailURL;
		public string thumbnailURL {
			get {
				if ( _thumbnailURL == null ) {
					this.GetMore();
				}
				return _thumbnailURL;
			}
			private set {
				this._thumbnailURL = value;
			}
		}
		private string _communityName;
		public string communityName {
			get {
				if ( _communityName == null ) {
					this.GetMore();
				}
				return _communityName;
			}
			private set {
				this._communityName = value;
			}
		}

		public AlertInfo() {
			flag = 0;
		}
		
		public AlertInfo(string broadcastID , string communityID , string userID) {
			flag = 1;
			this.broadcastID = "lv" + broadcastID;
			this.communityID = communityID;
			this.userID = userID;
		}

		public bool GetMore() {
			if ( flag != 1 ) return false;

			flag = 2;
			string text = HttpPost("http://live.nicovideo.jp/api/getstreaminfo/" + broadcastID);
			XmlDocument xml = new XmlDocument();
			xml.LoadXml(text);

			try {
				this.title						= xml["getstreaminfo"]["streaminfo"]["title"].InnerText;
				this.description			= xml["getstreaminfo"]["streaminfo"]["description"].InnerText;
				this.requestID				= xml["getstreaminfo"]["request_id"].InnerText;
				this.thumbnailURL		= xml["getstreaminfo"]["communityinfo"]["thumbnail"].InnerText;
				this.communityName	= xml["getstreaminfo"]["communityinfo"]["name"].InnerText;
				return true;
			}
			catch(Exception error) {
				Console.WriteLine("error - " + error);
				return false;
			}
		}
	}

	/*
	 * ハッシュテーブルに要素詰め込んだら、
	 * コメント以外に動画再生とかdisconnectとかも同じクラスで最小限のデータで送れるのではという案。
		public enum CommentCategory {
			comment , disconnect , hogehoge
		}

		public class CommentTest {
			public CommentCategory Category { get; private set; }
			public Hashtable Element{get;private set;}
		
			public CommentTest() {

			}
			/// <summary>
			/// 通常コメント
			/// </summary>
			/// <param name="data"></param>
			public CommentTest(XmlDocument data) {
				try {
					this.Category = CommentCategory.comment;
					Element["text"] = data["chat"].InnerText;
					Element["anonymity"] = ( data["chat"].GetAttribute("anonymity")  == "1")?true:false;
					Element["date"] = long.Parse(data["chat"].GetAttribute("date"));
					Element["mail"] = data["chat"].GetAttribute("mail");
					Element["no"] = int.Parse(data["chat"].GetAttribute("no"));
					Element["user_id"] = data["chat"].GetAttribute("user_id");
					Element["premium"] = int.Parse(data["chat"].GetAttribute("premium"));
				} catch {

				}
			}
		}
	*/

	public class Comment {
		public string text { get; private set; }
		public bool anonymity { get; private set; }
		public long date { get; private set; }
		public string mail { get; private set; }
		public int no { get; private set; }
		public int premium { get; private set; }
		public string user_id { get; private set; }

		private bool _ngflag;
		public bool ngflag {
			get {
				if ( _ngflag == null ) {
					//ToDo:NG検出処理
					_ngflag = false;
				}
				return _ngflag;
			}
			private set {
				this._ngflag = value;
			}
		}

		public Comment() {

		}

		public Comment(string text,string mail) {
			this.text = text;
			this.mail = mail;
		}

		/// <summary>
		/// 通常コメント
		/// </summary>
		/// <param name="data"></param>
		public Comment(XmlDocument data) {
			try {
				this.text = data["chat"].InnerText;
				this.anonymity = ( data["chat"].GetAttribute("anonymity")  == "1")?true:false;
				this.date = long.Parse(data["chat"].GetAttribute("date"));
				this.mail = data["chat"].GetAttribute("mail");
				this.no = int.Parse(data["chat"].GetAttribute("no"));
				this.user_id = data["chat"].GetAttribute("user_id");
			} catch(Exception ex) {
				Console.WriteLine("error - " + ex.Message);
			}
		}
	}

	class LiveInfo {

	}

	class CommunityInfo {
		
	}

	class UserInfo {

	}
}
