﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.Web;
using System.IO;

namespace NicoLib {
	public class Live : Nico {
		#region public
		public bool status { get; private set; }
		#endregion

		#region private
		private Thread getCommentThread;

		private string broadcastID;
		private string addr;
		private string port;
		private string thread;
		private string ticket;
		private string user_id;
		private string is_premium;
		private int res_from;
		private string postKey;
		#endregion

		/// <summary>
		/// コメントが投稿されたときのイベント
		/// </summary>
		/// <param name="Comment"></param>
		public delegate void CommentHandler(Comment comment);
		public event CommentHandler getCommentEvent;

		#region 初期化関係
		/// <summary>
		/// コンストラクタ - ログイン
		/// </summary>
		public Live(string mail , string password)
			: base(mail , password) {
			initialization();
		}

		private void initialization() {
			this.status = false;
		}
		#endregion

		public bool Start(string lvno) {
			return Start(lvno , -1);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="lvno">放送番号(lv***)</param>
		/// <param name="no">過去レス数(マイナスで指定)</param>
		/// <returns></returns>
		public bool Start(string lvno,int no) {
			if ( status == true ) return false;
			if ( GetOption(lvno) == false ) return false;
			this.broadcastID = lvno;
			this.res_from = no;

			//スレ建て
			status = true;
			getCommentThread = new Thread(new ThreadStart(this.GetCommentMain));
			getCommentThread.IsBackground = true;
			getCommentThread.Start();
			return true;
		}

		private bool GetOption(string lvno) {
			string text = HttpPost("http://live.nicovideo.jp/api/getplayerstatus" , "v={0}" , lvno);
			XmlDocument xml = new XmlDocument();
			xml.LoadXml(text);
			try {
				this.addr = xml.SelectSingleNode("getplayerstatus/ms/addr").InnerText;
				this.port = xml.SelectSingleNode("getplayerstatus/ms/port").InnerText;
				this.thread = xml.SelectSingleNode("getplayerstatus/ms/thread").InnerText;
				this.user_id = xml.SelectSingleNode("getplayerstatus/user/user_id").InnerText;
				this.is_premium = xml.SelectSingleNode("getplayerstatus/user/is_premium").InnerText;
				/*
				 * 立ち見入ったり立ち見からアリーナ見たりする時用
				Console.WriteLine(xml.SelectSingleNode("	getplayerstatus/user/room_label").InnerText);
				thread = ( int.Parse(thread) + 1 ).ToString();
				port = ( int.Parse(port) + 1 ).ToString();
				 */
				return true;
			}
			catch(Exception ex) {
				Console.WriteLine(ex.Message);
				return false;
			}
		}

		private void GetCommentMain() {
			using ( TcpClient tc = new TcpClient(addr , int.Parse(port)) )
			using ( NetworkStream ns = tc.GetStream() ) {
				string req = string.Format("<thread thread=\"{0}\" res_from=\"{1}\" version=\"20061206\" /> " , thread , res_from);

				byte[] sendBytes = Encoding.UTF8.GetBytes(req);
				sendBytes[sendBytes.Length - 1] = 0;
				ns.Write(sendBytes , 0 , sendBytes.Length);

				bool flag = true;
				while ( ns.CanRead && flag ) {
					byte[] resBytes = new byte[500];
					int resSize = ns.Read(resBytes , 0 , resBytes.Length);
					if ( resSize == 0 ) break;
					string message = Encoding.UTF8.GetString(resBytes);
					string[] elements = message.Split(new string[] { "\0" } , StringSplitOptions.RemoveEmptyEntries);

					foreach ( string receiveData in elements ) {
						CommentCheck(receiveData);
					}
				}
			}
		}

		private void CommentCheck(string text) {
			if ( text.StartsWith("<chat") ) {
				//comment
				try {
					XmlDocument receiveXML = new XmlDocument();
					receiveXML.LoadXml(text);
					Comment comment = new Comment(receiveXML);
					this.getCommentEvent(comment);
					if ( comment.no % 100 == 0 ) GetPostKey(comment.no);
				} catch {
					Console.WriteLine("error - " + text);
				}
			} else if ( text.StartsWith("<thread") ) {
				try {
					XmlDocument receiveXML = new XmlDocument();
					receiveXML.LoadXml(text);
					ticket = receiveXML["thread"].GetAttribute("ticket");

					GetPostKey(int.Parse(receiveXML["thread"].GetAttribute("last_res")));
				} catch {
					Console.WriteLine("error - " + text);
				}
			}
		}
		
		public void SendComment(Comment comment) {
			Thread thread = new Thread(new ParameterizedThreadStart(this.SendCommentThread));
			thread.IsBackground = true;
			thread.Start(comment);
		}

		private void GetPostKey(int no) {
			this.postKey = HttpPost("http://watch.live.nicovideo.jp/api/getpostkey" , "thread={0}&block_no={1}" , thread , (no/100).ToString());
			this.postKey = this.postKey.Substring(8 , this.postKey.Length - 8);
		}

		private void SendCommentThread(object obj) {
			Comment comment = (Comment)obj;

			using ( TcpClient tc = new TcpClient(addr , int.Parse(port)) )
			using ( NetworkStream ns = tc.GetStream() ) {

                string mes = string.Format("<chat thread=\"{1}\" ticket=\"{2}\" vpos=\"{3}\" postkey=\"{4}\" mail=\"{5}\" user_id=\"{6}\" premium=\"{7}\">{0}</chat> \0 "
					, comment.text, thread, ticket, 0, postKey, comment.mail, user_id,is_premium);
                byte[] sendBytes = System.Text.Encoding.UTF8.GetBytes(mes);
                
                ns.Write(sendBytes, 0, sendBytes.Length);
            }
        }


		/// <summary>
		/// 接続を切断する
		/// </summary>
		/// <returns></returns>
		public bool DisConnect() {
			try {
				getCommentThread.Abort();
				status = false;
				return true;
			} catch {
				return false;
			}
		}
	}
}
