package nicolib.api;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;

import nicolib.NicoText;
import nicolib.util.Http;
import nicolib.util.Logger;

/**
 * ニコニコ動画全体に関するAPIを取り扱うクラス
 * @author hal
 *
 */
public class Common {
	
	private final static String LOGINPAGE_URL = "https://secure.nicovideo.jp/secure/login?site=niconico";
	private final static String MYPAGE_URL = "http://www.nicovideo.jp/my";
	private final static String MYPAGE_SYMBOL = "さんのマイページ";
	
	/**
	 * アカウント情報からニコニコ動画へのログインを実行する
	 * @param mail
	 * @param password
	 * @return ログインできたかどうか
	 * @throws NicoApiException
	 */
	public static boolean login(String mail, String password)
		throws NicoApiException
	{

		String param = String.format("mail=%s&password=%s&next_url=", mail, password);
		HttpURLConnection http = null;
		try {
			
			http = Http.postConnection(LOGINPAGE_URL, param, null);
			String cookies = http.getHeaderField("Set-Cookie");
	        String userSession = NicoText.getUserSession(cookies);
	        if(userSession != null){
	        	Http.setUserSession(userSession);
	        	return true;
	        }
			
		} catch (MalformedURLException e) {
			Logger.writeException(e);
		} catch (IOException e) {
			Logger.write(String.format("BasicApi.doLogin ログイン失敗 \n message:%s\n stacktrace\n%s", e, e.getStackTrace()));
			throw new NicoApiException("ログイン時にネットワークエラーが発生しました", e);
		} finally {
			if(http != null) http.disconnect();
		}
		
		return false;
	}

	/**
	 * 現在ログイン状態にあるかどうか調べる
	 * @return ログイン状態かどうか
	 * @throws NicoApiException
	 */
	public static boolean checkSession()
		throws NicoApiException
	{
		try{
			String response = Http.Get(MYPAGE_URL); 
			return response.contains(MYPAGE_SYMBOL);
		} catch (MalformedURLException e) {
			Logger.writeException(e);
		} catch (IOException e) {
			Logger.write(String.format("BasicApi.checkSession マイページアクセス失敗 \n message:%s\n stacktrace\n%s", e, e.getStackTrace()));
			throw new NicoApiException("マイページの取得に失敗しました", e);
		}
		
		return false;
	}
}
