package nicolib.api;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;

import nicolib.util.Http;
import nicolib.util.Logger;

/**
 * name1=value1&name2=value2&...形式のAPIの抽象クラス
 * @author hal
 *
 */
public abstract class UrlParamApiBase extends ApiBase {
	
		
	protected HashMap<String, String> hashmap;
	

	@Override
	public String select(String location) {
		return hashmap.get(location);
	}
	
	/**
	 * 指定したURLのAPIへアクセスする
	 * 失敗時には既定では３回まで接続を試みる
	 * @param url
	 * @throws NicoApiException
	 */
	protected void access(String url) 
		throws NicoApiException
	{
		try {
			String res = Http.TryGet(url, retryCount);
			if(res.equals("")) throw new NicoApiException(String.format("API(%s)の取得に失敗しました。", url));
			
			hash(res);
			
		} catch (IOException e) {
			throw new NicoApiException(String.format("XML(%s)の取得に失敗しました", url), e);
		}
	}
	
	/**
	 * 指定したURLのAPIへPOSTでアクセスする
	 * 失敗時には既定では３回まで接続を試みる
	 * @param url
	 * @param param
	 * @param referer
	 * @throws NicoApiException
	 */
	protected void access(String url, String param, String referer) 
		throws NicoApiException
	{
		try {
			String res = Http.TryPost(url, param, referer, retryCount);
			if(res.equals("")) throw new NicoApiException(String.format("API(%s)の取得に失敗しました。", url));
			
			hash(res);
			
		} catch (IOException e) {
			throw new NicoApiException(String.format("XML(%s)の取得に失敗しました", url), e);
		}
	}
	
	private void hash(String text){
		hashmap = new HashMap<String, String>();
		String[] params = text.split("&");
		for(String param : params){
			String[] data = param.split("=");
			if(data.length == 2){
				try {
					String key = URLDecoder.decode(data[0], "UTF-8");
					String value = URLDecoder.decode(data[1], "UTF-8");
					
					hashmap.put(key, value);
					
				} catch (UnsupportedEncodingException e) {
					Logger.writeException(e, true);
				}
			}
		}
	}

}
