package nicolib.api.alert;

import java.util.Date;

import nicolib.api.AsyncLoadHandler;
import nicolib.api.NicoApiException;
import nicolib.api.XmlApiBase;
import nicolib.util.Logger;

/**
 * アラートのユーザー認証を行わないタイプのAPI
 * @author hal
 *
 */
public class AlertInfo extends XmlApiBase {

	private static final String API_URL = "http://live.nicovideo.jp/api/getalertinfo";
	
	
	/**
	 * AlertInfoを取得する
	 * [APIUrl] http://live.nicovideo.jp/api/getalertinfo
	 * @return AlertInfo
	 * @throws NicoApiException
	 */
	public static AlertInfo get() throws NicoApiException{
		AlertInfo info = new AlertInfo();
		info.access(API_URL);
		return info;
	}
	
	/**
	 * AlertInfoを非同期で取得する
	 * [APIUrl] http://live.nicovideo.jp/api/getalertinfo
	 * @param handler
	 * @throws NicoApiException
	 */
	public static void getAsnyc(AsyncLoadHandler handler) throws NicoApiException{
		AlertInfo info = new AlertInfo();
		info.accessAsync(API_URL, handler);
	}
	
	protected AlertInfo(){
	}
	
	/**
	 * APIへのアクセス時間
	 * @return
	 */
	public Date getAccessTime(){
		return selectDate("getalertstatus/@time");
	}
	
	/**
	 * ユーザーID
	 * @return
	 */
	public int getUserId(){
		return selectInt("getalertstatus/user_id", 0);
	}
	
	/**
	 * 
	 * @return
	 */
	public String getUserHash(){
		return select("getalertstatus/user_hash");
	}
	
	/**
	 * コメントサーバーのアドレス
	 * @return
	 */
	public String getAddr(){
		return select("getalertstatus/ms/addr");
	}
	
	/**
	 * コメントサーバーのポート
	 * @return
	 */
	public int getPort(){
		return selectInt("getalertstatus/ms/port", 0);
	}
	
	/**
	 * アラートのスレッド
	 * @return
	 */
	public int getThread(){
		return selectInt("getalertstatus/ms/thread", 0);
	}
	
	@Override
	public String getErrorCode() {
		return select("getalertstatus/error/code");
	}

	@Override
	public String getErrorMessage() {
		String errorCode = getErrorCode();
		
		if(hasError()){
			if(errorCode == null){
				return "AlertInfoの取得に失敗しました。";
			}else{
				Logger.write("AlertInfo UnknownErrorCode:" + errorCode);
				return "未定義のエラーが発生しました";
			}
		}else{
			return "エラーはありません";
		}
	}

	@Override
	public boolean hasError() {
		String status = select("getalertstatus/@status");
		return status == null || !status.equals("ok");
	}

}
