package nicolib.api.alert;

import nicolib.api.AsyncLoadHandler;
import nicolib.api.NicoApiException;
import nicolib.api.XmlApiBase;
import nicolib.util.Logger;

/**
 * アラートのログインAPI
 * @author hal
 *
 */
public class AlertLogin extends XmlApiBase {

	private static final String API_URL = "https://secure.nicovideo.jp/secure/login?site=nicolive_antenna";
	private static final String PARAM_FORMAT = "mail=%s&password=%s";
	
	
	/**
	 * アカウント情報からAlertLoginを取得する
	 * [APIUrl] https://secure.nicovideo.jp/secure/login?site=nicolive_antenna
	 * @param mail メールアドレス
	 * @param password パスワード
	 * @return AlertLogin
	 * @throws NicoApiException
	 */
	public static AlertLogin get(String mail, String password) throws NicoApiException{
		if(mail == null){
			throw new IllegalArgumentException("mailがnullです。");
		}
		
		if(password == null){
			throw new IllegalArgumentException("passwordがnullです。");
		}
	
		AlertLogin data = new AlertLogin();
		data.access(API_URL, String.format(PARAM_FORMAT, mail, password), null);
		
		return data;
	}
	
	/**
	 * アカウント情報からAlertLoginを非同期で取得する
	 * [APIUrl] https://secure.nicovideo.jp/secure/login?site=nicolive_antenna
	 * @param mail メールアドレス
	 * @param password パスワード
	 * @param handler
	 * @throws NicoApiException
	 */
	public static void getAsync(String mail, String password, AsyncLoadHandler handler) throws NicoApiException{
		if(mail == null){
			throw new IllegalArgumentException("mailがnullです。");
		}
		
		if(password == null){
			throw new IllegalArgumentException("passwordがnullです。");
		}
	
		AlertLogin data = new AlertLogin();
		data.accessAsync(API_URL, String.format(PARAM_FORMAT, mail, password), null, handler);
	}
	
	private AlertLogin() 
	{
	}
	
	/**
	 * チケット
	 * @return
	 */
	public String getTicket(){
		return select("nicovideo_user_response/ticket");
	}
		
	@Override
	public String getErrorCode() {
		return select("nicovideo_user_response/error/code");
	}

	@Override
	public String getErrorMessage() {
		String errorCode = getErrorCode();
		
		if(hasError()){
			if(errorCode == null){
				return "AlertLoginの取得に失敗しました。";
			}else if(errorCode.equals("1")){
				return "メールアドレスまたはパスワードが間違っているため、ログインできません";
			}else{
				Logger.write("AlertLogin UnknownErrorCode:" + errorCode);
				return "未定義のエラーが発生しました";
			}
		}else{
			return "エラーはありません";
		}
		
	}

	@Override
	public boolean hasError() {
		String status = select("nicovideo_user_response/@status");
		return status == null || !status.equals("ok");
	}

}
