package nicolib.comment;

import nicolib.api.NicoApiException;
import nicolib.api.alert.AlertInfo;
import nicolib.api.alert.AlertStatus;
import nicolib.api.alert.StreamInfo;
import nicolib.util.Logger;

/**
 * アラートサーバーから情報を取得するためのクラス
 * @author hal
 *
 */
public class AlertReceiver extends ClientBase {
	
	private AlertStatus alertStatus;
	private AlertReceiverHandler alertHandler;
	private boolean withStreamInfo = false;
	
	public AlertStatus getAlertStatus() {
		return alertStatus;
	}
	
	/**
	 * アラート通知を受け取るハンドラを設定します
	 * @param handler
	 */
	public void setHandler(AlertReceiverHandler handler){
		this.alertHandler = handler;
	}
	
	/**
	 * ログイン無しでアラートサーバーに接続します
	 * @param withStreamInfo 通知を受け取った際にStreamInfoも同時に取得するかどうか
	 * @return 接続を開始できたか
	 * @throws NicoApiException
	 */
	public boolean connectServer(boolean withStreamInfo) throws NicoApiException{
		AlertInfo info = AlertInfo.get();
		if(!info.hasError()){
			return connectServer(info, withStreamInfo);
		}
		return false;
	}
	
	/**
	 * 事前に取得したAlertStatusを元にサーバーに接続します
	 * (AlertStatusの利用は今後の実装で)
	 * @param status 
	 * @param withStreamInfo 通知を受け取った際にStreamInfoも同時に取得するかどうか
	 * @return 接続を開始できたか
	 */
	public boolean connectServer(AlertStatus status, boolean withStreamInfo){
		alertStatus = status;
		return connectServer(status, withStreamInfo);
	}
	
	/**
	 * 事前に取得したAlertInfoを元にサーバーに接続します
	 * @param info
	 * @param withStreamInfo 通知を受け取った際にStreamInfoも同時に取得するかどうか
	 * @return
	 */
	public boolean connectServer(AlertInfo info, boolean withStreamInfo){
		this.withStreamInfo = withStreamInfo;
		return super.connectServer(info.getAddr(), info.getPort(), info.getThread(), -1);
	}
	
	/**
	 * サーバーから受け取った情報の解析結果をハンドラーに渡します
	 */
	protected void commentServ(Object obj, String text){
		
		if(alertHandler != null){
			if(obj instanceof Chat){
				AlertChat achat = new AlertChat((Chat)obj);
				alertHandler.receiveAlertChat(achat, text);
				
				if(withStreamInfo){
					StreamInfo info = null;
					try {
						info = StreamInfo.get(achat.liveId);	
					} catch (NicoApiException e) {
						Logger.writeException(e);
					}
					alertHandler.receiveStreamInfo(info, achat);
				}
				
				return;
			}
		}
			
		super.commentServ(obj, text);
	}
}
